/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.android.kernel.utilities;

import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.models.internal.QueryParameters;
import java.util.ArrayList;
import java.util.Map;

public class ContentParameters
extends QueryParameters {
    private Builder.ContentFilterType filterType;
    private String filterId = null;

    private ContentParameters(Builder builder) {
        this.addPaging(builder.limit, builder.offset);
        this.filterType = builder.filterType;
        this.filterId = builder.filterId;
    }

    public Map<String, ArrayList<String>> getQueryParams() {
        Map params = super.getQueryParams();
        if (this.filterType == Builder.ContentFilterType.ALL || this.filterType == Builder.ContentFilterType.ID) {
            ArrayList<String> limitParam = new ArrayList<String>();
            limitParam.add(String.valueOf(true));
            params.put("data", limitParam);
        }
        return params;
    }

    public Builder.ContentFilterType getFilterType() {
        return this.filterType;
    }

    public String getFilterId() {
        return this.filterId;
    }

    public static class Builder {
        private ContentFilterType filterType;
        private String filterId = null;
        private long limit = 0L;
        private long offset = -1L;

        public Builder addPaging(int limit, int offset) {
            this.limit = limit;
            this.offset = offset;
            return this;
        }

        public Builder addFilter(ContentFilterType filter, Object ... params) throws FlybitsException {
            this.filterType = filter;
            if (this.filterType == ContentFilterType.ID) {
                if (params.length >= 1 && params[0] instanceof String) {
                    this.filterId = (String)params[0];
                } else {
                    throw new FlybitsException("ContentParam Error: invalid params");
                }
            }
            return this;
        }

        public ContentParameters build() {
            return new ContentParameters(this);
        }

        public static enum ContentFilterType {
            ALL,
            RELEVANT,
            ID;

        }
    }
}

