package com.flybits.android.kernel.models.results;

import android.content.Context;

import com.flybits.android.kernel.models.Experience;
import com.flybits.android.kernel.utilities.ExperienceParameters;
import com.flybits.commons.library.api.results.PagedResult;
import com.flybits.commons.library.api.results.callbacks.PagedResultCallback;
import com.flybits.commons.library.models.internal.QueryParameters;

import java.util.concurrent.ExecutorService;

public class ExperienceResult extends PagedResult<Experience> {

    public ExperienceResult(Context context, PagedResultCallback<Experience> callback){
        super(context, callback);
    }

    public ExperienceResult(Context context, PagedResultCallback<Experience> callback, ExecutorService service){
        super(context, callback, service);
    }

    @Override
    protected <K extends QueryParameters> ExperienceResult getMore(Context context, K parameters,
                                                       PagedResultCallback<Experience> callback) {
        return Experience.get(context, (ExperienceParameters) parameters, callback);
    }

}
