/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.android.kernel.models;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcel;
import android.os.Parcelable;
import com.flybits.android.kernel.api.FlyContentData;
import com.flybits.android.kernel.models.internal.ContentDataResponse;
import com.flybits.android.kernel.utilities.ContentDataDeserializer;
import com.flybits.commons.library.api.results.BasicResult;
import com.flybits.commons.library.api.results.callbacks.BasicResultCallback;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.models.internal.Result;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class PagedArray<T extends Parcelable>
implements Parcelable {
    private String mContentInstanceId;
    private String mFieldPath;
    private long mCurrentOffset = 0L;
    private long mTotalRecords;
    private long mLimit;
    private ArrayList<T> mCurrentDownloaded;
    private Class mTemplateModel;
    public static final Parcelable.Creator<PagedArray> CREATOR = new Parcelable.Creator<PagedArray>(){

        public PagedArray createFromParcel(Parcel in) {
            return new PagedArray(in);
        }

        public PagedArray[] newArray(int size) {
            return new PagedArray[size];
        }
    };

    public PagedArray(String contentInstanceId, String fieldPath, Class model, long totalRecords, long limit, long offset, ArrayList<T> list) {
        this.mContentInstanceId = contentInstanceId;
        this.mFieldPath = fieldPath;
        this.mTotalRecords = totalRecords;
        this.mLimit = limit;
        this.mCurrentOffset = offset + limit;
        if (this.mCurrentOffset >= this.mTotalRecords) {
            this.mCurrentOffset = this.mTotalRecords;
        }
        this.mCurrentDownloaded = list;
        this.mTemplateModel = model;
    }

    public PagedArray(Parcel in) {
        this.mContentInstanceId = in.readString();
        this.mFieldPath = in.readString();
        this.mCurrentOffset = in.readLong();
        this.mTotalRecords = in.readLong();
        this.mLimit = in.readLong();
        int listSize = in.readInt();
        if (listSize > 0) {
            Class type = (Class)in.readSerializable();
            this.mCurrentDownloaded = new ArrayList(listSize);
            in.readList(this.mCurrentDownloaded, type.getClassLoader());
        }
        try {
            this.mTemplateModel = Class.forName(in.readString());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void getNext(Context context, int limit) throws FlybitsException {
        if (!this.hasNext()) {
            return;
        }
        Result result = FlyContentData.getPaged(context, this, this.mCurrentOffset, limit);
        PagedArray newPagedArray = ContentDataDeserializer.extractPagedArray(((ContentDataResponse)((Object)result.getResult())).getItems().get(0), this.mFieldPath);
        this.mTotalRecords = newPagedArray.mTotalRecords;
        this.mCurrentOffset += (long)limit;
        this.mLimit = newPagedArray.mLimit;
        this.mCurrentDownloaded.addAll(newPagedArray.getList());
        if (this.mCurrentOffset >= this.mTotalRecords) {
            this.mCurrentOffset = this.mTotalRecords;
        }
    }

    public void getNext(final Context context, final long limit, BasicResultCallback callback) {
        if (!this.hasNext()) {
            callback.onSuccess();
        }
        final Handler handler = new Handler(Looper.getMainLooper());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final BasicResult result = new BasicResult(context, callback, executorService);
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    final Result pageResult = FlyContentData.getPaged(context, PagedArray.this, PagedArray.this.mCurrentOffset, limit);
                    PagedArray newPagedArray = ContentDataDeserializer.extractPagedArray(((ContentDataResponse)((Object)pageResult.getResult())).getItems().get(0), PagedArray.this.mFieldPath);
                    if (newPagedArray == null) {
                        handler.post(new Runnable(){

                            @Override
                            public void run() {
                                result.setFailed(pageResult.getException());
                            }
                        });
                    } else {
                        PagedArray.this.mTotalRecords = newPagedArray.mTotalRecords;
                        PagedArray.this.mCurrentOffset = PagedArray.this.mCurrentOffset + limit;
                        PagedArray.this.mLimit = newPagedArray.mLimit;
                        PagedArray.this.mCurrentDownloaded.addAll(newPagedArray.getList());
                        if (PagedArray.this.mCurrentOffset >= PagedArray.this.mTotalRecords) {
                            PagedArray.this.mCurrentOffset = PagedArray.this.mTotalRecords;
                        }
                        handler.post(new Runnable(){

                            @Override
                            public void run() {
                                result.setResult(pageResult);
                            }
                        });
                    }
                }
                catch (FlybitsException e) {
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            result.setFailed(e);
                        }
                    });
                }
            }
        });
    }

    public boolean hasNext() {
        return this.mCurrentOffset < this.mTotalRecords;
    }

    public ArrayList<T> getList() {
        return this.mCurrentDownloaded;
    }

    public String getInstanceId() {
        return this.mContentInstanceId;
    }

    public String getPath() {
        return this.mFieldPath;
    }

    public String getName() {
        if (this.mFieldPath.contains(".")) {
            return this.mFieldPath.substring(this.mFieldPath.lastIndexOf(".") + 1);
        }
        return this.mFieldPath;
    }

    public Class getTemplateModel() {
        return this.mTemplateModel;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mContentInstanceId);
        dest.writeString(this.mFieldPath);
        dest.writeLong(this.mCurrentOffset);
        dest.writeLong(this.mTotalRecords);
        dest.writeLong(this.mLimit);
        dest.writeInt(this.mCurrentDownloaded.size());
        if (this.mCurrentDownloaded != null) {
            Class<?> objectsType = ((Parcelable)this.mCurrentDownloaded.get(0)).getClass();
            dest.writeSerializable(objectsType);
            dest.writeList(this.mCurrentDownloaded);
        }
        dest.writeString(this.mTemplateModel.getName());
    }
}

