package com.flybits.android.kernel.db.caching;

import android.content.Context;

import com.flybits.android.kernel.db.KernelDatabase;
import com.flybits.android.kernel.models.Content;
import com.flybits.commons.library.caching.FlybitsCacheLoader;

import java.util.List;

/**
 * The {@code ContentCacheLoader} is responsible for loading cached data associated to a
 * {@link Content}. This data is inserted into the local SQLite DB whenever {@link Content} data is
 * received from the Flybits server.
 */
public class ContentCacheLoader extends FlybitsCacheLoader<Content> {

    private Context context;

    public ContentCacheLoader(Context context){
        this.context    = context;
    }

    @Override
    public List<Content> load() {
        return KernelDatabase.getDatabase(context).contentDao().getAll();
    }
}
