package com.flybits.android.kernel.models.internal;

import android.support.annotation.NonNull;

import com.flybits.commons.library.models.internal.PagedResponse;
import com.flybits.commons.library.models.internal.Pagination;

import java.util.ArrayList;

/**
 * Contains the response object from Flybits which contains a list of retrieved {@code ContentData}
 * instances as well as the {@code Pagination} object which indicates how many {@code ContentData}s were
 * retrieved from the Flybits network request as well as all paging information.
 */
public class ContentDataResponse<T> extends PagedResponse<T> {

    private String instanceId;

    /**
     * Default Constructor which sets the returned {@code ContentData}s and the {@code Pagination}
     * object associated to this network request.
     * @param data The {@code ContentData}s returned for the network request.
     * @param instanceId The instance id this data belongs to.
     * @param pagination The {@code Pagination} object returned for the network request.
     */
    public ContentDataResponse(@NonNull ArrayList<T> data, @NonNull String instanceId, @NonNull Pagination pagination) {
        super(data, pagination);
        this.instanceId = instanceId;
    }

    /**
     * Get the content instance id for this data.
     * @return The instance id this data belongs to.
     */
    public String getInstanceId() {
        return instanceId;
    }
}


