package com.flybits.android.kernel.models;

import android.os.Parcel;
import android.os.Parcelable;

import com.flybits.commons.library.models.JsonParser;

import org.json.JSONException;
import org.json.JSONObject;

public class SurveyMetadata implements Parcelable, JsonParser
{
    public static final String SURVEY_JSON_ANSWERS = "surveyAnswersInstanceID";
    public static final String SURVEY_JSON_QUESTIONS = "surveyQuestionsInstanceID";
    public static final String SURVEY_JSON_RESULT = "surveyResultInstanceID";

    private String surveyAnswersInstanceID;
    private String surveyQuestionsInstanceID;
    private String surveyResultInstanceID;

    public SurveyMetadata()
    {
        surveyAnswersInstanceID = "";
        surveyQuestionsInstanceID = "";
        surveyResultInstanceID = "";
    }

    public SurveyMetadata(JSONObject jsonObject)
    {
        fromJson(jsonObject.toString());
    }

    protected SurveyMetadata(Parcel in)
    {
        surveyAnswersInstanceID = in.readString();
        surveyQuestionsInstanceID = in.readString();
        surveyResultInstanceID = in.readString();
    }

    public JSONObject toJson()
    {
        JSONObject jsonObject = new JSONObject();

        try
        {
            jsonObject.put(SURVEY_JSON_ANSWERS, surveyAnswersInstanceID);
            jsonObject.put(SURVEY_JSON_QUESTIONS, surveyQuestionsInstanceID);
            jsonObject.put(SURVEY_JSON_RESULT, surveyResultInstanceID);
        }
        catch (JSONException e)
        {
            e.printStackTrace();
        }

        return jsonObject;
    }

    @Override
    public void fromJson(String json)
    {
        try
        {
            JSONObject jsonObject = new JSONObject(json);
            surveyAnswersInstanceID = jsonObject.getString(SURVEY_JSON_ANSWERS);
            surveyQuestionsInstanceID = jsonObject.getString(SURVEY_JSON_QUESTIONS);
            surveyResultInstanceID = jsonObject.getString(SURVEY_JSON_RESULT);
        }
        catch (JSONException e)
        {
            e.printStackTrace();
        }
    }

    public static final Creator<SurveyMetadata> CREATOR = new Creator<SurveyMetadata>()
    {
        @Override
        public SurveyMetadata createFromParcel(Parcel in)
        {
            return new SurveyMetadata(in);
        }

        @Override
        public SurveyMetadata[] newArray(int size)
        {
            return new SurveyMetadata[size];
        }
    };


    public String getSurveyAnswersInstanceID()
    {
        return surveyAnswersInstanceID;
    }

    public String getSurveyQuestionsInstanceID()
    {
        return surveyQuestionsInstanceID;
    }

    public String getSurveyResultInstanceID()
    {
        return surveyResultInstanceID;
    }

    @Override
    public int describeContents()
    {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags)
    {
        dest.writeString(surveyAnswersInstanceID);
        dest.writeString(surveyQuestionsInstanceID);
        dest.writeString(surveyResultInstanceID);
    }
}
