package com.flybits.android.kernel.db.converters;

import android.arch.persistence.room.TypeConverter;

import com.flybits.android.kernel.models.SurveyMetadata;
import com.flybits.commons.library.models.JsonParser;

import org.json.JSONException;
import org.json.JSONObject;

public class JsonParserConverters
{
    @TypeConverter
    public static JsonParser fromString(String json)
    {
        try
        {
            JSONObject jsonObject = new JSONObject(json);
            if (!jsonObject.isNull(SurveyMetadata.SURVEY_JSON_ANSWERS) && !jsonObject.isNull(SurveyMetadata.SURVEY_JSON_QUESTIONS))
            {
                return new SurveyMetadata(jsonObject);
            }
        }
        catch (JSONException e)
        {
            e.printStackTrace();
        }

        return null;
    }

    @TypeConverter
    public static String jsonParserToString(JsonParser value)
    {
        return value.toJson().toString();
    }
}
