/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.android.kernel.utilities;

import com.flybits.android.kernel.models.LocalizedValue;
import com.flybits.android.kernel.models.PagedArray;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.logging.Logger;
import java.lang.reflect.Field;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ContentDataSerializer {
    public static String serialize(Object object) throws FlybitsException {
        return ContentDataSerializer.serializeObject(object).toString();
    }

    private static JSONObject serializeObject(Object currentObject) throws FlybitsException {
        JSONObject jsonObject = new JSONObject();
        for (Field f : currentObject.getClass().getDeclaredFields()) {
            try {
                if (f.getName().equals("CREATOR")) continue;
                if (f.get(currentObject) == null) {
                    if (LocalizedValue.class.isAssignableFrom(f.getType())) continue;
                    jsonObject.put(f.getName(), JSONObject.NULL);
                    continue;
                }
                if (PagedArray.class.isAssignableFrom(f.getType())) {
                    jsonObject.put(f.getName(), (Object)ContentDataSerializer.serializeArray(((PagedArray)f.get(currentObject)).getList()));
                    continue;
                }
                if (ArrayList.class.isAssignableFrom(f.getType())) {
                    jsonObject.put(f.getName(), (Object)ContentDataSerializer.serializeArray((ArrayList)f.get(currentObject)));
                    continue;
                }
                if (LocalizedValue.class.isAssignableFrom(f.getType())) {
                    JSONObject localizationsObject = null;
                    try {
                        localizationsObject = jsonObject.getJSONObject("localizations");
                    }
                    catch (JSONException jSONException) {
                        // empty catch block
                    }
                    if (localizationsObject == null) {
                        localizationsObject = new JSONObject();
                        jsonObject.put("localizations", (Object)localizationsObject);
                    }
                    LocalizedValue value = (LocalizedValue)f.get(currentObject);
                    for (String lang : value.getListOfSupportedLanguages()) {
                        if (!localizationsObject.has(lang)) {
                            localizationsObject.put(lang, (Object)new JSONObject());
                        }
                        localizationsObject.optJSONObject(lang).put(f.getName(), (Object)value.getValue(lang));
                    }
                    continue;
                }
                if (ContentDataSerializer.checkIfPrimitiveType(f.getType())) {
                    jsonObject.put(f.getName(), f.get(currentObject));
                    continue;
                }
                jsonObject.put(f.getName(), (Object)ContentDataSerializer.serializeObject(f.get(currentObject)));
            }
            catch (IllegalAccessException e) {
                Logger.exception((String)"ContentDataSerializer.serializeObject", (Exception)e);
                throw new FlybitsException("ContentDataSerializer.serializeObject.RELFECTION_ERROR");
            }
            catch (JSONException e) {
                Logger.exception((String)"ContentDataSerializer.serializeObject", (Exception)((Object)e));
                throw new FlybitsException("ContentDataSerializer.serializeObject.JSON_SERIALIZATION_ERROR");
            }
        }
        return jsonObject;
    }

    private static JSONArray serializeArray(ArrayList array) throws FlybitsException {
        JSONArray jsonArray = new JSONArray();
        for (int i = 0; i < array.size(); ++i) {
            if (ContentDataSerializer.checkIfPrimitiveType(array.get(i).getClass())) {
                jsonArray.put(array.get(i));
                continue;
            }
            jsonArray.put((Object)ContentDataSerializer.serializeObject(array.get(i)));
        }
        return jsonArray;
    }

    private static boolean checkIfPrimitiveType(Class type) {
        return type.getName().equals("java.lang.String") || type.getName().equals("java.lang.Boolean") || type.getName().equals("boolean") || type.getName().equals("java.lang.Float") || type.getName().equals("float") || type.getName().equals("java.lang.Double") || type.getName().equals("double") || type.getName().equals("java.lang.Integer") || type.getName().equals("int") || type.getName().equals("java.lang.Long") || type.getName().equals("long");
    }
}

