/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.android.kernel.deserializers;

import android.content.Context;
import android.support.annotation.NonNull;
import com.flybits.android.kernel.models.Content;
import com.flybits.commons.library.SharedElements;
import com.flybits.commons.library.deserializations.IDeserializer;
import com.flybits.commons.library.logging.Logger;
import java.util.ArrayList;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DeserializeContentInstance
extends IDeserializer<Content> {
    private Context mContext;

    public DeserializeContentInstance(@NonNull Context context) {
        this.mContext = context;
    }

    public String toJson(Content contentResponse) {
        JSONObject objectLanguageCode;
        JSONObject object = new JSONObject();
        JSONObject localizationObject = new JSONObject();
        ArrayList<String> listofCodes = new ArrayList<String>();
        for (String code : contentResponse.getNameObject().getListOfSupportedLanguages()) {
            try {
                if (contentResponse.getName(code) == null) continue;
                listofCodes.add(code);
                objectLanguageCode = new JSONObject();
                objectLanguageCode.put("name", (Object)contentResponse.getName(code));
                localizationObject.put(code, (Object)objectLanguageCode);
                if (contentResponse.getDescription(code) == null) continue;
                objectLanguageCode.put("description", (Object)contentResponse.getDescription(code));
                localizationObject.put(code, (Object)objectLanguageCode);
            }
            catch (JSONException e) {
                Logger.exception((String)"DeserializeContentInstance.toJson", (Exception)((Object)e));
            }
        }
        for (String code : contentResponse.getDescriptionObject().getListOfSupportedLanguages()) {
            try {
                if (listofCodes.contains(code) || contentResponse.getDescription(code) == null) continue;
                objectLanguageCode = new JSONObject();
                objectLanguageCode.put("description", (Object)contentResponse.getDescription(code));
                localizationObject.put(code, (Object)objectLanguageCode);
            }
            catch (JSONException e) {
                Logger.exception((String)"DeserializeContentInstance.toJson", (Exception)((Object)e));
            }
        }
        try {
            object.put("localizations", (Object)localizationObject);
            if (contentResponse.getIcon() != null) {
                object.put("iconUrl", (Object)contentResponse.getIcon());
            }
            object.put("templateId", (Object)contentResponse.getTemplateId());
            object.put("templateType", (Object)contentResponse.getType());
        }
        catch (JSONException e) {
            Logger.exception((String)"DeserializeContentInstance.toJson", (Exception)((Object)e));
        }
        return object.toString();
    }

    public Content fromJson(JSONObject jsonObject) {
        try {
            String id = jsonObject.getString("id");
            String templateId = jsonObject.getString("templateId");
            long createdAt = -1L;
            if (!jsonObject.isNull("createdAt")) {
                createdAt = jsonObject.getLong("createdAt");
            }
            long modifiedAt = -1L;
            if (!jsonObject.isNull("modifiedAt")) {
                modifiedAt = jsonObject.getLong("modifiedAt");
            }
            String iconUrl = null;
            if (!jsonObject.isNull("iconUrl")) {
                iconUrl = jsonObject.getString("iconUrl");
            }
            String type = null;
            if (!jsonObject.isNull("templateType")) {
                type = jsonObject.getString("templateType");
            }
            JSONObject dataContainer = jsonObject.optJSONObject("content");
            String data = null;
            if (dataContainer != null) {
                data = dataContainer.toString();
            }
            ArrayList<String> labels = new ArrayList<String>();
            if (!jsonObject.isNull("labels")) {
                JSONArray jsonArray = jsonObject.getJSONArray("labels");
                for (int i = 0; i < jsonArray.length(); ++i) {
                    labels.add(jsonArray.getString(i));
                }
            }
            Content instance = new Content(id, templateId, iconUrl, "en", SharedElements.getEnabledLanguagesAsString((Context)this.mContext), createdAt, modifiedAt, data, labels, type);
            if (!jsonObject.isNull("localizations")) {
                JSONObject localizationObject = jsonObject.getJSONObject("localizations");
                Iterator languages = localizationObject.keys();
                while (languages.hasNext()) {
                    String language = (String)languages.next();
                    JSONObject languageObj = localizationObject.getJSONObject(language);
                    if (!languageObj.isNull("description")) {
                        instance.setDescription(language, languageObj.getString("description"));
                    }
                    if (languageObj.isNull("name")) continue;
                    instance.setName(language, languageObj.getString("name"));
                }
            }
            return instance;
        }
        catch (JSONException e) {
            Logger.exception((String)"DeserializeContentInstance.fromJson", (Exception)((Object)e));
            return null;
        }
    }

    public Content fromJson(JSONArray jsonArray) {
        return null;
    }
}

