package com.flybits.android.kernel.reservedtemplates.survey.models;

import android.os.Parcel;
import android.os.Parcelable;

import com.flybits.android.kernel.models.LocalizedValue;

import java.util.ArrayList;

/**
 * This POJO defines a single question in a Survey, when requesting the data from a {@code SurveyQuestion}
 * content instance.
 */

public class Question implements Parcelable {

    public ArrayList<QuestionChoice> choices;
    public Long questionNumber = 0L;
    public LocalizedValue question;
    public String type;

    public Question(){}

    protected Question(Parcel in)
    {
        choices = in.createTypedArrayList(QuestionChoice.CREATOR);
        if (in.readByte() == 0)
        {
            questionNumber = null;
        }
        else
        {
            questionNumber = in.readLong();
        }
        question = in.readParcelable(LocalizedValue.class.getClassLoader());
        type = in.readString();
    }

    public static final Creator<Question> CREATOR = new Creator<Question>()
    {
        @Override
        public Question createFromParcel(Parcel in)
        {
            return new Question(in);
        }

        @Override
        public Question[] newArray(int size)
        {
            return new Question[size];
        }
    };

    @Override
    public int describeContents()
    {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags)
    {
        dest.writeTypedList(choices);
        if (questionNumber == null)
        {
            dest.writeByte((byte) 0);
        }
        else
        {
            dest.writeByte((byte) 1);
            dest.writeLong(questionNumber);
        }
        dest.writeParcelable(question, flags);
        dest.writeString(type);
    }
}
