package com.flybits.android.kernel.db;

import android.arch.persistence.db.SupportSQLiteDatabase;
import android.arch.persistence.room.Database;
import android.arch.persistence.room.Room;
import android.arch.persistence.room.RoomDatabase;
import android.arch.persistence.room.TypeConverters;
import android.arch.persistence.room.migration.Migration;
import android.content.Context;

import com.flybits.android.kernel.db.converters.ListStringConverters;
import com.flybits.android.kernel.db.converters.LocalizedValueConverters;
import com.flybits.android.kernel.db.dao.ContentDao;
import com.flybits.android.kernel.db.dao.GroupDao;
import com.flybits.android.kernel.models.Content;
import com.flybits.android.kernel.models.Group;

@Database(entities = {Content.class, Group.class}, version = 4)
@TypeConverters({LocalizedValueConverters.class, ListStringConverters.class})
public abstract class KernelDatabase extends RoomDatabase{

    private static KernelDatabase INSTANCE;
    public abstract ContentDao contentDao();
    public abstract GroupDao groupDao();

    public static KernelDatabase getDatabase(Context context) {
        if (INSTANCE == null) {
            INSTANCE = Room.databaseBuilder(context, KernelDatabase.class, "flybits-kernel-db")
                    .addMigrations(MIGRATION_1_4)
                    .addMigrations(MIGRATION_3_4)
                    .build();
        }
        return INSTANCE;
    }

    static final Migration MIGRATION_3_4 = new Migration(3, 4) {
        @Override
        public void migrate(SupportSQLiteDatabase database) {
            database.execSQL("ALTER TABLE content ADD COLUMN labels TEXT");
        }
    };
    static final Migration MIGRATION_1_4 = new Migration(1, 4) {
        @Override
        public void migrate(SupportSQLiteDatabase database) {
            database.execSQL("ALTER TABLE content ADD COLUMN labels TEXT");
            database.execSQL("ALTER TABLE content ADD COLUMN type TEXT");
        }
    };

    public static void destroy() {
        INSTANCE = null;
    }

}
