package com.flybits.android.kernel.db.caching;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;

import com.flybits.android.kernel.db.KernelDatabase;
import com.flybits.android.kernel.models.Group;
import com.flybits.commons.library.caching.FlybitsCacheLoader;

import java.util.List;

/**
 * The {@code GroupCacheLoader} is responsible for loading cached data associated to a
 * {@link Group}. This data is inserted into the local SQLite DB whenever {@link Group} data is
 * received from the Flybits server.
 */
public class GroupCacheLoader extends FlybitsCacheLoader<Group> {

    /**
     * Constructor used to define a {@link GroupCacheLoader} class with the Context parameter.
     *
     * @param context The context of the activity that created this object.
     * @deprecated Use {@link #GroupCacheLoader(Activity)} as it is more optimized.
     */
    @Deprecated
    public GroupCacheLoader(Context context){
        super(context);
    }

    /**
     * Constructor used to define a {@link GroupCacheLoader} class with the Activity parameter.
     *
     * @param activity The activity that created this object.
     */
    public GroupCacheLoader(Activity activity){
        super(activity);
    }

    @Override
    public List<Group> load(List<String> listOfIds, int limit) {
        return KernelDatabase.getDatabase(getContext()).groupDao().getByCachedIds(listOfIds, limit);
    }

    @Override
    protected Group load(String id) {
        if (id != null){
            return KernelDatabase.getDatabase(getContext()).groupDao().getById(id);
        }
        return null;
    }

    /**
     * This get method is used to retrieve the cached entities associated to the {@link Group}
     * model.
     *
     * @param cachingKey The caching key used to define which {@link Group} entities should be
     *                   retrieved.
     * @param callback The {@code CacheListLoader} callback that loads the cached data.
     * @return This {@link #GroupCacheLoader} object.
     */
    public GroupCacheLoader get(@NonNull String cachingKey, CacheListLoader<Group> callback){
        super.getList(cachingKey, callback);
        return this;
    }

    /**
     * This get method is used to retrieve the cached entities associated to the {@link Group}
     * model. This method contains a limit of the number of {@link Group} that should be retrieved.
     *
     * @param cachingKey The caching key used to define which {@link Group} entities should be
     *                   retrieved.
     * @param limit The number entries that should be returned.
     * @param callback The {@code CacheListLoader} callback that loads the cached data.
     * @return This {@link #GroupCacheLoader} object.
     */
    public GroupCacheLoader get(@NonNull String cachingKey, int limit, CacheListLoader<Group> callback){
        super.getList(cachingKey, limit, callback);
        return this;
    }
}
