package com.flybits.android.kernel.db.dao;

import android.arch.lifecycle.LiveData;
import android.arch.persistence.room.Dao;
import android.arch.persistence.room.Insert;
import android.arch.persistence.room.Query;

import com.flybits.android.kernel.models.Content;

import java.util.List;

import static android.arch.persistence.room.OnConflictStrategy.REPLACE;

@Dao
public interface ContentDao {

    /**
     * Get Requests
     */
    @Query("SELECT * FROM content WHERE id = :id")
    Content getById(String id);

    @Query("SELECT * FROM content")
    List<Content> getAll();

    @Query("SELECT * FROM content WHERE id IN (:ids)")
    List<Content> getByCachedIds(List<String> ids);

    @Query("SELECT * FROM content WHERE id IN (:ids) LIMIT :limit")
    List<Content> getByCachedIds(List<String> ids, int limit);

    @Query("SELECT * FROM content WHERE templateId = :templateId")
    List<Content> getAllByTemplateId(String templateId);

    /**
     * BASIC CRUD
     */
    @Insert(onConflict = REPLACE)
    void insert(List<Content> content);

    @Query("DELETE FROM content")
    void clear();

    @Query("DELETE FROM content WHERE id IN (:ids)")
    void deleteByIds(List<String> ids);

    /**
     * LIVE DATA
     */
    @Query("SELECT * FROM content")
    LiveData<List<Content>> getLive();

    @Query("SELECT * FROM content WHERE id IN (:ids)")
    LiveData<List<Content>> getLiveByCacheIds(List<String> ids);

    @Query("SELECT * FROM content WHERE id = :id")
    LiveData<List<Content>> getLiveById(String id);

    @Query("SELECT * FROM content WHERE templateId = :templateId")
    LiveData<List<Content>> getLiveAllByTemplateId(String templateId);
}
