package com.flybits.android.kernel;


import android.content.Context;
import android.os.AsyncTask;

import com.flybits.android.kernel.db.KernelDatabase;
import com.flybits.commons.library.api.FlybitsScope;
import com.flybits.commons.library.models.User;

public class KernelScope extends FlybitsScope{

    public static final String ROOT = "/kernel";

    public static KernelScope SCOPE = new KernelScope();

    private KernelScope(){
        super("Kernel");
    }

    @Override
    public void onConnected(Context context, User user) {}

    @Override
    public void onDisconnected(Context context, String s) {
        new ClearDatabase(context).execute();
    }

    @Override
    public void onAccountDestroyed(Context context, String s) {
        new ClearDatabase(context).execute();
    }

    private class ClearDatabase extends AsyncTask<Void, Void, Void> {

        private Context context;

        public ClearDatabase(Context context){
            this.context    = context;
        }

        protected Void doInBackground(Void... urls) {
            KernelDatabase.getDatabase(context).contentDao().clear();
            KernelDatabase.getDatabase(context).groupDao().clear();
            return null;
        }
    }
}
