package com.flybits.android.kernel.reservedtemplates.survey.models;

import android.os.Parcel;
import android.os.Parcelable;

import java.util.ArrayList;

/**
 * This POJO defines a single question in a Survey, when requesting the data from a {@code SurveyQuestion}
 * content instance.
 */

public class Question implements Parcelable {

    public ArrayList<QuestionChoice> choices;
    public Long questionNumber = 0L;
    public String question;
    public String type;

    public Question(){}

    protected Question(Parcel in) {
        question = in.readString();
        type = in.readString();
        questionNumber = in.readLong();
        in.readTypedList(choices, QuestionChoice.CREATOR);
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(question);
        dest.writeString(type);
        dest.writeLong(questionNumber);
        dest.writeTypedList(choices);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<Question> CREATOR = new Creator<Question>() {
        @Override
        public Question createFromParcel(Parcel in) {
            return new Question(in);
        }

        @Override
        public Question[] newArray(int size) {
            return new Question[size];
        }
    };

}
