/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.android.kernel.models;

import android.arch.persistence.room.Entity;
import android.arch.persistence.room.Ignore;
import android.arch.persistence.room.PrimaryKey;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.flybits.android.kernel.api.FlyContentData;
import com.flybits.android.kernel.db.KernelDatabase;
import com.flybits.android.kernel.deserializers.DeserializeContentDatum;
import com.flybits.android.kernel.deserializers.DeserializeContentInstance;
import com.flybits.android.kernel.models.LocalizedValue;
import com.flybits.android.kernel.models.internal.ContentDataResponse;
import com.flybits.android.kernel.models.results.ContentResult;
import com.flybits.android.kernel.utilities.ContentDataParameters;
import com.flybits.android.kernel.utilities.ContentDataSerializer;
import com.flybits.android.kernel.utilities.ContentParameters;
import com.flybits.commons.library.api.FlyAway;
import com.flybits.commons.library.api.results.BasicResult;
import com.flybits.commons.library.api.results.ObjectResult;
import com.flybits.commons.library.api.results.callbacks.BasicResultCallback;
import com.flybits.commons.library.api.results.callbacks.ObjectResultCallback;
import com.flybits.commons.library.api.results.callbacks.PagedResultCallback;
import com.flybits.commons.library.deserializations.DeserializePagedResponse;
import com.flybits.commons.library.deserializations.IDeserializer;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.http.RequestStatus;
import com.flybits.commons.library.models.internal.PagedResponse;
import com.flybits.commons.library.models.internal.QueryParameters;
import com.flybits.commons.library.models.internal.Result;
import com.flybits.commons.library.models.internal.SortByEnumeratable;
import com.flybits.internal.db.CommonsDatabase;
import com.flybits.internal.db.models.CachingEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

@Entity(tableName="content")
public class Content
implements Parcelable {
    public static final String API_CONTENT_RELEVANT_INSTANCES = "/kernel/experiences/contents";
    public static final String API_CONTENT_INSTANCE = "/kernel/content/instances";
    public static final String API_CONTENT_INSTANCE_WITHDATA = "/kernel/content/instances/%s?data=true";
    @PrimaryKey
    @NonNull
    private String id;
    private String templateId;
    private LocalizedValue nameObject;
    private LocalizedValue descriptionObject;
    private long createdAt;
    private long modifiedAt;
    private String icon;
    private String dataAsJson;
    private String type;
    @Ignore
    private Parcelable deserializedObject;
    private ArrayList<String> labels;
    public static final Parcelable.Creator<Content> CREATOR = new Parcelable.Creator<Content>(){

        public Content createFromParcel(Parcel in) {
            return new Content(in);
        }

        public Content[] newArray(int size) {
            return new Content[size];
        }
    };

    public Content() {
    }

    @Deprecated
    @Ignore
    private Content(@NonNull String id, @NonNull String templateId, String iconUrl, @NonNull String defaultLanguage, @NonNull String defaultDeviceLangauge, long createdAt, long modifiedAt, ArrayList<String> labels) {
        this(id, templateId, iconUrl, defaultLanguage, defaultDeviceLangauge, createdAt, modifiedAt, labels, "");
    }

    @Ignore
    private Content(@NonNull String id, @NonNull String templateId, String iconUrl, @NonNull String defaultLanguage, @NonNull String defaultDeviceLangauge, long createdAt, long modifiedAt, ArrayList<String> labels, String type) {
        this.id = id;
        this.templateId = templateId;
        this.icon = iconUrl;
        this.createdAt = createdAt;
        this.modifiedAt = modifiedAt;
        this.nameObject = new LocalizedValue(defaultLanguage, defaultDeviceLangauge);
        this.descriptionObject = new LocalizedValue(defaultLanguage, defaultDeviceLangauge);
        this.labels = labels;
        this.type = type;
    }

    @Ignore
    protected Content(Parcel in) {
        this(in.readString(), in.readString(), in.readString(), in.readString(), in.readString(), in.readLong(), in.readLong(), in.createStringArrayList(), in.readString());
        this.nameObject = (LocalizedValue)in.readParcelable(LocalizedValue.class.getClassLoader());
        this.descriptionObject = (LocalizedValue)in.readParcelable(LocalizedValue.class.getClassLoader());
        if (in.readInt() == 1) {
            this.dataAsJson = in.readString();
        }
        if (in.readInt() == 1) {
            this.deserializedObject = in.readParcelable(Parcelable.class.getClassLoader());
        }
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.id);
        dest.writeString(this.templateId);
        dest.writeString(this.icon);
        dest.writeString(this.nameObject.getEntityDefaultLanguage());
        dest.writeString(this.nameObject.getDeviceDefaultLanguage());
        dest.writeLong(this.createdAt);
        dest.writeLong(this.modifiedAt);
        dest.writeStringList(this.labels);
        dest.writeString(this.type);
        dest.writeParcelable((Parcelable)this.nameObject, flags);
        dest.writeParcelable((Parcelable)this.descriptionObject, flags);
        dest.writeInt(this.dataAsJson != null ? 1 : 0);
        if (this.dataAsJson != null) {
            dest.writeString(this.dataAsJson);
        }
        dest.writeInt(this.deserializedObject != null ? 1 : 0);
        if (this.deserializedObject != null) {
            dest.writeParcelable(this.deserializedObject, flags);
        }
    }

    @Deprecated
    public Content(@NonNull String id, @NonNull String templateId, String iconUrl, @NonNull String defaultLanguage, @NonNull String defaultDeviceLangauge, long createdAt, long modifiedAt, @NonNull String dataJson, ArrayList<String> labels) {
        this(id, templateId, iconUrl, defaultLanguage, defaultDeviceLangauge, createdAt, modifiedAt, labels, "");
        this.dataAsJson = dataJson;
    }

    public Content(@NonNull String id, @NonNull String templateId, String iconUrl, @NonNull String defaultLanguage, @NonNull String defaultDeviceLangauge, long createdAt, long modifiedAt, @NonNull String dataJson, ArrayList<String> labels, String type) {
        this(id, templateId, iconUrl, defaultLanguage, defaultDeviceLangauge, createdAt, modifiedAt, labels, type);
        this.dataAsJson = dataJson;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public String getDataAsJson() {
        return this.dataAsJson;
    }

    public String getDescription() {
        return this.descriptionObject.getValue();
    }

    public String getDescription(String langauge) {
        return this.descriptionObject.getValue(langauge);
    }

    public LocalizedValue getDescriptionObject() {
        return this.descriptionObject;
    }

    @Nullable
    public String getIcon() {
        return this.icon;
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    public ArrayList<String> getLabels() {
        if (this.labels == null) {
            this.labels = new ArrayList();
        }
        return this.labels;
    }

    public long getModifiedAt() {
        return this.modifiedAt;
    }

    public String getName() {
        return this.nameObject.getValue();
    }

    public String getName(String language) {
        return this.nameObject.getValue(language);
    }

    public LocalizedValue getNameObject() {
        return this.nameObject;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public String getType() {
        return this.type;
    }

    public void setCreatedAt(long createdAt) {
        this.createdAt = createdAt;
    }

    public void setDataAsJson(String dataAsJson) {
        this.dataAsJson = dataAsJson;
    }

    public void setDescription(@NonNull String languageCode, @NonNull String description) {
        this.descriptionObject.addValue(languageCode, description);
    }

    public void setDescriptionObject(LocalizedValue description) {
        this.descriptionObject = description;
    }

    public void setIcon(@Nullable String icon) {
        this.icon = icon;
    }

    public void setId(@NonNull String id) {
        this.id = id;
    }

    public void setLabels(ArrayList<String> labels) {
        this.labels = labels == null ? new ArrayList() : labels;
    }

    public void setModifiedAt(long modifiedAt) {
        this.modifiedAt = modifiedAt;
    }

    public void setName(@NonNull String languageCode, @NonNull String name) {
        this.nameObject.addValue(languageCode, name);
    }

    public void setNameObject(LocalizedValue name) {
        this.nameObject = name;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public void setType(String type) {
        this.type = type;
    }

    public <T extends Parcelable> T getData(Context context, Class modelClass) throws FlybitsException {
        if (this.deserializedObject != null) {
            return (T)this.deserializedObject;
        }
        ContentDataResponse response = new DeserializeContentDatum(context, this.id, modelClass).fromJson(this.dataAsJson);
        if (response == null) {
            throw new FlybitsException("Parsing Error");
        }
        ArrayList root = response.getItems();
        if (root != null && root.size() != 0) {
            this.deserializedObject = (Parcelable)root.get(0);
        }
        return (T)this.deserializedObject;
    }

    public static ContentResult get(final @NonNull Context context, final @NonNull ContentParameters params, final PagedResultCallback<Content> callback) {
        final Handler handler = new Handler(Looper.getMainLooper());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final ContentResult result = new ContentResult(context, callback, executorService);
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    String url = params.getUrl();
                    DeserializeContentInstance singleDeserializer = new DeserializeContentInstance(context);
                    DeserializePagedResponse deserializer = new DeserializePagedResponse((IDeserializer)singleDeserializer);
                    final Result resultGetInstances = FlyAway.get((Context)context, (String)url, (QueryParameters)params, (IDeserializer)deserializer, (String)"Content.get");
                    if (resultGetInstances.getStatus() == RequestStatus.COMPLETED) {
                        if ((params.getQueryParams().get("offset") == null || params.getQueryParams().get("offset").size() == 0 || params.getQueryParams().get("offset").get(0).equals("0")) && params.getCachingKey() != null) {
                            List listOfIds = CommonsDatabase.getDatabase((Context)context).cachingEntryDAO().getIdsByCachingKey(params.getCachingKey());
                            KernelDatabase.getDatabase(context).contentDao().deleteByIds(listOfIds);
                            CommonsDatabase.getDatabase((Context)context).cachingEntryDAO().deleteAllByCachingKey(params.getCachingKey());
                        }
                        if (params.getCachingKey() != null) {
                            ArrayList<CachingEntry> entries = new ArrayList<CachingEntry>();
                            for (Content content : ((PagedResponse)resultGetInstances.getResult()).getItems()) {
                                entries.add(new CachingEntry(params.getCachingKey(), content.getId()));
                            }
                            KernelDatabase.getDatabase(context).contentDao().insert(((PagedResponse)resultGetInstances.getResult()).getItems());
                            CommonsDatabase.getDatabase((Context)context).cachingEntryDAO().insert(entries);
                        }
                    }
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            result.setResult(resultGetInstances, params);
                        }
                    });
                }
                catch (FlybitsException e) {
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            callback.onException(e);
                        }
                    });
                }
            }
        });
        return result;
    }

    public static ObjectResult<Content> getById(final Context context, final String id, final ObjectResultCallback<Content> callback) {
        final Handler handler = new Handler(Looper.getMainLooper());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final ObjectResult result = new ObjectResult(context, callback, executorService);
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    String url = String.format(Content.API_CONTENT_INSTANCE_WITHDATA, id);
                    DeserializeContentInstance singleDeserializer = new DeserializeContentInstance(context);
                    final Result resultGetInstance = FlyAway.get((Context)context, (String)url, (IDeserializer)singleDeserializer, (String)"Content.getbyid", Content.class);
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            result.setResult(resultGetInstance);
                        }
                    });
                }
                catch (FlybitsException e) {
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            callback.onException(e);
                        }
                    });
                }
            }
        });
        return result;
    }

    public static ContentResult get(Context context, ContentParameters params) {
        return Content.get(context, params, null);
    }

    public static <T> ObjectResult<ContentDataResponse<T>> getData(final Context context, final ContentDataParameters params, final Class<T> classObj, ObjectResultCallback<ContentDataResponse<T>> callback) {
        final Handler handler = new Handler(Looper.getMainLooper());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final ObjectResult result = new ObjectResult(context, callback, executorService);
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    final Result resultGetInstances = FlyContentData.get(context, params, classObj);
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            result.setResult(resultGetInstances);
                        }
                    });
                }
                catch (FlybitsException e) {
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            result.setFailed(e);
                        }
                    });
                }
            }
        });
        return result;
    }

    public BasicResult saveData(final @NonNull Context context, final @NonNull Object objectToSave, final @NonNull BasicResultCallback callback) {
        if (context == null) {
            throw new IllegalArgumentException("The context parameter must not be null.");
        }
        if (objectToSave == null) {
            throw new IllegalArgumentException("The object being saved must not be null.");
        }
        final Handler handler = new Handler(Looper.getMainLooper());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final BasicResult request = new BasicResult(context, callback, executorService);
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    String json = ContentDataSerializer.serialize(objectToSave);
                    final Result resultPostData = FlyContentData.post(context, Content.this, json);
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            request.setResult(resultPostData);
                        }
                    });
                }
                catch (FlybitsException e) {
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            callback.onException(e);
                        }
                    });
                }
            }
        });
        return request;
    }

    public int describeContents() {
        return 0;
    }

    public static enum SortBy implements SortByEnumeratable
    {
        PRIORITY("index"),
        EVALUATED_AT("evaluatedAt"),
        CREATED_AT("createdAt"),
        MODIFIED_AT("modifiedAt");

        private String value;

        private SortBy(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public String getValue() {
            return this.toString();
        }

        public static SortBy fromValue(String key) {
            for (SortBy type : SortBy.values()) {
                if (!type.getValue().equalsIgnoreCase(key)) continue;
                return type;
            }
            return CREATED_AT;
        }
    }
}

