/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.android.kernel.db;

import android.arch.persistence.db.SupportSQLiteDatabase;
import android.arch.persistence.room.Database;
import android.arch.persistence.room.Room;
import android.arch.persistence.room.RoomDatabase;
import android.arch.persistence.room.TypeConverters;
import android.arch.persistence.room.migration.Migration;
import android.content.Context;
import com.flybits.android.kernel.db.converters.ListStringConverters;
import com.flybits.android.kernel.db.converters.LocalizedValueConverters;
import com.flybits.android.kernel.db.dao.ContentDao;
import com.flybits.android.kernel.db.dao.GroupDao;
import com.flybits.android.kernel.models.Content;
import com.flybits.android.kernel.models.Group;

@Database(entities={Content.class, Group.class}, version=4)
@TypeConverters(value={LocalizedValueConverters.class, ListStringConverters.class})
public abstract class KernelDatabase
extends RoomDatabase {
    private static KernelDatabase INSTANCE;
    static final Migration MIGRATION_3_4;
    static final Migration MIGRATION_1_3;
    static final Migration MIGRATION_1_4;

    public abstract ContentDao contentDao();

    public abstract GroupDao groupDao();

    public static KernelDatabase getDatabase(Context context) {
        if (INSTANCE == null) {
            INSTANCE = (KernelDatabase)Room.databaseBuilder((Context)context, KernelDatabase.class, (String)"flybits-kernel-db").addMigrations(new Migration[]{MIGRATION_1_3}).addMigrations(new Migration[]{MIGRATION_1_4}).addMigrations(new Migration[]{MIGRATION_3_4}).build();
        }
        return INSTANCE;
    }

    public static void destroy() {
        INSTANCE = null;
    }

    static {
        MIGRATION_3_4 = new Migration(3, 4){

            public void migrate(SupportSQLiteDatabase database) {
                database.execSQL("ALTER TABLE content ADD labels TEXT");
            }
        };
        MIGRATION_1_3 = new Migration(1, 3){

            public void migrate(SupportSQLiteDatabase database) {
            }
        };
        MIGRATION_1_4 = new Migration(1, 4){

            public void migrate(SupportSQLiteDatabase database) {
                database.execSQL("ALTER TABLE content ADD labels TEXT");
            }
        };
    }
}

