package com.flybits.android.kernel.db.caching;

import android.content.Context;
import android.support.annotation.NonNull;

import com.flybits.android.kernel.db.KernelDatabase;
import com.flybits.android.kernel.models.Group;
import com.flybits.commons.library.caching.FlybitsCacheLoader;

import java.util.List;

/**
 * The {@code GroupCacheLoader} is responsible for loading cached data associated to a
 * {@link Group}. This data is inserted into the local SQLite DB whenever {@link Group} data is
 * received from the Flybits server.
 */
public class GroupCacheLoader extends FlybitsCacheLoader<Group> {

    public GroupCacheLoader(Context context){
        super(context);
    }

    @Override
    public List<Group> load(List<String> listOfIds) {
        return KernelDatabase.getDatabase(getContext()).groupDao().getByCacheIds(listOfIds);
    }

    @Override
    public void get(@NonNull final String cachingKey, final CacheLoader<Group> callback){
        super.get(cachingKey, callback);
    }
}
