package com.flybits.android.kernel.db.caching;

import android.content.Context;
import android.support.annotation.NonNull;

import com.flybits.android.kernel.db.KernelDatabase;
import com.flybits.android.kernel.models.Content;
import com.flybits.android.kernel.models.Group;
import com.flybits.commons.library.caching.FlybitsCacheLoader;

import java.util.List;

/**
 * The {@code ContentCacheLoader} is responsible for loading cached data associated to a
 * {@link Content}. This data is inserted into the local SQLite DB whenever {@link Content} data is
 * received from the Flybits server.
 */
public class ContentCacheLoader extends FlybitsCacheLoader<Content> {

    public ContentCacheLoader(Context context){
        super(context);
    }

    public List<Content> load(List<String> listOfIds) {
        return KernelDatabase.getDatabase(getContext()).contentDao().getByCacheIds(listOfIds);
    }

    public Content load(String id){
        return KernelDatabase.getDatabase(getContext()).contentDao().getById(id);
    }

    @Override
    public void get(@NonNull final String cachingKey, final CacheLoader<Content> callback){
        super.get(cachingKey, callback);
    }
}
