/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.android.kernel.api;

import android.content.Context;
import android.support.annotation.NonNull;
import com.flybits.android.kernel.deserializers.DeserializeContentDatum;
import com.flybits.android.kernel.models.Content;
import com.flybits.android.kernel.models.PagedArray;
import com.flybits.android.kernel.models.internal.ContentDataResponse;
import com.flybits.android.kernel.utilities.ContentDataParameters;
import com.flybits.commons.library.api.FlybitsAPIConstants;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.http.HttpDefaultClass;
import com.flybits.commons.library.http.RequestStatus;
import com.flybits.commons.library.logging.Logger;
import com.flybits.commons.library.models.internal.Result;
import java.io.IOException;

public class FlyContentData {
    static final String API_CONTENT_DATA = "/kernel/content/instances/%1$s/data";
    static final String API_CONTENT_DATA_PAGED = "/kernel/content/instances/%1$s/data?fields=%2$s&expand=%2$s&%2$s.offset=%3$d&%2$s.limit=%4$d";

    public static <T> Result<ContentDataResponse<T>> getPaged(@NonNull Context context, @NonNull PagedArray array, long offset, long limit) throws FlybitsException {
        if (context == null) {
            throw new IllegalArgumentException("The context parameter must not be null.");
        }
        if (array == null) {
            throw new IllegalArgumentException("The array parameter must not be null.");
        }
        String url = String.format(FlybitsAPIConstants.constructGatewayURL((Context)context, (String)API_CONTENT_DATA_PAGED), array.getInstanceId(), array.getName(), offset, limit);
        try {
            Result result = new HttpDefaultClass.Builder(context, true, url).get().getResponse();
            Class clazz = array.getTemplateModel();
            if (result.getStatus() == RequestStatus.COMPLETED) {
                ContentDataResponse response = new DeserializeContentDatum(context, array.getInstanceId(), clazz).fromJson(result.getResultAsString());
                if (response != null) {
                    result.setResponse(response);
                } else {
                    result = new Result(new FlybitsException("Parsing Error"), result.getResultAsString());
                }
            }
            return result;
        }
        catch (IOException e) {
            Logger.exception((String)"FlyContentData.get", (Exception)e);
            throw new FlybitsException("Error Connecting to Flybits Server: FlyContentData_EXP1");
        }
    }

    public static <T> Result<ContentDataResponse<T>> get(@NonNull Context context, @NonNull ContentDataParameters params, @NonNull Class classObj) throws FlybitsException {
        if (context == null) {
            throw new IllegalArgumentException("The context parameter must not be null.");
        }
        if (params == null || params.getInstanceID() == null) {
            throw new IllegalArgumentException("The content object must not be null.");
        }
        if (classObj == null) {
            throw new IllegalArgumentException("The class object must not be null.");
        }
        String url = String.format(FlybitsAPIConstants.constructGatewayURL((Context)context, (String)API_CONTENT_DATA), params.getInstanceID());
        try {
            Result result = new HttpDefaultClass.Builder(context, true, url).get().getResponse();
            if (result.getStatus() == RequestStatus.COMPLETED) {
                ContentDataResponse response = new DeserializeContentDatum(context, params.getInstanceID(), classObj).fromJson(result.getResultAsString());
                if (response != null) {
                    result.setResponse(response);
                } else {
                    result = new Result(new FlybitsException("Parsing Error"), result.getResultAsString());
                }
            }
            return result;
        }
        catch (IOException e) {
            Logger.exception((String)"FlyContentData.get", (Exception)e);
            throw new FlybitsException("Error Connecting to Flybits Server: FlyContentData_EXP2");
        }
    }

    public static <T> Result<T> post(@NonNull Context context, @NonNull Content content, @NonNull String json) throws FlybitsException {
        if (context == null) {
            throw new IllegalArgumentException("The context parameter must not be null.");
        }
        if (content == null || content.getId() == null) {
            throw new IllegalArgumentException("The content object must not be null.");
        }
        if (json == null) {
            throw new IllegalArgumentException("The json object must not be null.");
        }
        String url = String.format(FlybitsAPIConstants.constructGatewayURL((Context)context, (String)API_CONTENT_DATA), content.getId());
        try {
            Result result = new HttpDefaultClass.Builder(context, true, url).post(json).getResponse();
            return result;
        }
        catch (IOException e) {
            Logger.exception((String)"FlyContentData.post", (Exception)e);
            throw new FlybitsException("Error Connecting to Flybits Server: FlyContentData_EXP3");
        }
    }
}

