package com.flybits.android.kernel.db.caching;

import android.content.Context;

import com.flybits.android.kernel.db.KernelDatabase;
import com.flybits.android.kernel.models.Group;
import com.flybits.commons.library.caching.FlybitsCacheLoader;

import java.util.List;

/**
 * The {@code GroupCacheLoader} is responsible for loading cached data associated to a
 * {@link Group}. This data is inserted into the local SQLite DB whenever {@link Group} data is
 * received from the Flybits server.
 */
public class GroupCacheLoader extends FlybitsCacheLoader<Group> {

    private Context context;

    public GroupCacheLoader(Context context){
        this.context    = context;
    }

    @Override
    public List<Group> load() {
        return KernelDatabase.getDatabase(context).groupDao().getAll();
    }
}
