/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.android.kernel.utilities;

import android.support.annotation.NonNull;
import com.flybits.commons.library.models.internal.QueryBuilder;
import com.flybits.commons.library.models.internal.QueryParameters;
import java.util.ArrayList;
import java.util.Map;

public class ContentParameters
extends QueryParameters {
    private String locId;
    private double latitude;
    private double longitude;
    private double radius;
    private String url;
    private String templateId;

    private ContentParameters(Builder builder) {
        super((QueryBuilder)builder);
        this.locId = builder.locId;
        if (this.locId != null) {
            this.latitude = builder.latitude;
            this.longitude = builder.longitude;
            this.radius = builder.radius;
            if (builder.templateId != null) {
                this.templateId = builder.templateId;
            }
            this.url = "/kernel/content/instances";
        } else {
            this.url = "/kernel/experiences/contents";
        }
    }

    public Map<String, ArrayList<String>> getQueryParams() {
        Map params = super.getQueryParams();
        if (this.locId != null) {
            ArrayList<String> latitudeParam = new ArrayList<String>();
            latitudeParam.add(String.valueOf(this.latitude));
            params.put("latitude", latitudeParam);
            ArrayList<String> longitudeParam = new ArrayList<String>();
            longitudeParam.add(String.valueOf(this.longitude));
            params.put("longitude", longitudeParam);
            ArrayList<String> radiusParam = new ArrayList<String>();
            radiusParam.add(String.valueOf(this.radius));
            params.put("radius", radiusParam);
            ArrayList<String> locParam = new ArrayList<String>();
            locParam.add(String.valueOf(this.locId));
            params.put("loc", locParam);
            ArrayList<String> dataParam = new ArrayList<String>();
            dataParam.add(String.valueOf(true));
            params.put("data", dataParam);
            if (this.templateId != null) {
                ArrayList<String> templateIdParam = new ArrayList<String>();
                templateIdParam.add(String.valueOf(this.templateId));
                params.put("templateId", templateIdParam);
            }
        }
        return params;
    }

    public String getUrl() {
        return this.url;
    }

    public static class Builder
    extends QueryBuilder<Builder> {
        private String locId;
        private double latitude;
        private double longitude;
        private double radius;
        private String templateId;

        public Builder setSorting(@NonNull String loc, double latitude, double longitude, long radius) {
            return this.setSorting(loc, latitude, longitude, radius, null);
        }

        public Builder setSorting(@NonNull String loc, double latitude, double longitude, long radius, String templateId) {
            this.locId = loc;
            this.latitude = latitude;
            this.longitude = longitude;
            this.radius = radius;
            this.templateId = templateId;
            return this;
        }

        public ContentParameters build() {
            return new ContentParameters(this);
        }
    }
}

