package com.flybits.android.kernel.reservedtemplates.survey.models;

import android.os.Parcel;

/**
 * A POJO containing the resulting number of votes for a single choice question. Contained by
 * {@code Result} when requesting data from a {@code SurveyResult} content instance.
 */

public class ResultChoice extends Choice {

    public Long votes = 0L;

    public ResultChoice(){}

    protected ResultChoice(Parcel in) {
        super(in);
        votes = in.readLong();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeLong(votes);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<ResultChoice> CREATOR = new Creator<ResultChoice>() {
        @Override
        public ResultChoice createFromParcel(Parcel in) {
            return new ResultChoice(in);
        }

        @Override
        public ResultChoice[] newArray(int size) {
            return new ResultChoice[size];
        }
    };
}
