/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.android.kernel.utilities;

import android.support.annotation.NonNull;
import com.flybits.commons.library.models.internal.QueryBuilder;
import com.flybits.commons.library.models.internal.QueryParameters;
import java.util.ArrayList;
import java.util.Map;

public class ContentParameters
extends QueryParameters {
    private String locId;
    private double latitude;
    private double longitude;
    private double radius;
    private MeasurementUnit unit;
    private String url;

    private ContentParameters(Builder builder) {
        super((QueryBuilder)builder);
        this.locId = builder.locId;
        if (this.locId != null) {
            this.latitude = builder.latitude;
            this.longitude = builder.longitude;
            this.radius = builder.raidus;
            this.unit = builder.unit;
            this.url = "/kernel/content/instances";
        } else {
            this.url = "/kernel/experiences/contents";
        }
    }

    public Map<String, ArrayList<String>> getQueryParams() {
        Map params = super.getQueryParams();
        if (this.locId != null) {
            ArrayList<String> latitudeParam = new ArrayList<String>();
            latitudeParam.add(String.valueOf(this.latitude));
            params.put("latitude", latitudeParam);
            ArrayList<String> longitudeParam = new ArrayList<String>();
            longitudeParam.add(String.valueOf(this.longitude));
            params.put("longitude", longitudeParam);
            ArrayList<String> radiusParam = new ArrayList<String>();
            radiusParam.add(String.valueOf(this.radius));
            params.put("radius", radiusParam);
            ArrayList<String> locParam = new ArrayList<String>();
            locParam.add(String.valueOf(this.locId));
            params.put("loc", locParam);
            ArrayList<String> unitParam = new ArrayList<String>();
            unitParam.add(String.valueOf(this.unit.getKey()));
            params.put("unit", unitParam);
            ArrayList<String> dataParam = new ArrayList<String>();
            dataParam.add(String.valueOf(true));
            params.put("data", dataParam);
        }
        return params;
    }

    public String getUrl() {
        return this.url;
    }

    public static enum MeasurementUnit {
        METRIC("metric"),
        IMPERIAL("imperial");

        private final String key;

        private MeasurementUnit(String value) {
            this.key = value;
        }

        public String getKey() {
            return this.key;
        }

        public static MeasurementUnit fromValue(String value) {
            if (value == null) {
                return METRIC;
            }
            for (MeasurementUnit type : MeasurementUnit.values()) {
                if (!type.getKey().equalsIgnoreCase(value)) continue;
                return type;
            }
            return METRIC;
        }
    }

    public static class Builder
    extends QueryBuilder<Builder> {
        private String locId;
        private double latitude;
        private double longitude;
        private double raidus;
        private MeasurementUnit unit;

        public Builder setSorting(@NonNull String loc, double latitude, double longitude, long radius, MeasurementUnit unit) {
            this.locId = loc;
            this.latitude = latitude;
            this.longitude = longitude;
            this.raidus = radius;
            this.unit = unit;
            return this;
        }

        public ContentParameters build() {
            return new ContentParameters(this);
        }
    }
}

