/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.android.kernel.models;

import android.os.Parcel;
import android.os.Parcelable;

public class LocationData
implements Parcelable {
    private double lat;
    private double lng;
    private double distance;
    private Unit unit;
    public static final Parcelable.Creator<LocationData> CREATOR = new Parcelable.Creator<LocationData>(){

        public LocationData createFromParcel(Parcel in) {
            return new LocationData(in);
        }

        public LocationData[] newArray(int size) {
            return new LocationData[size];
        }
    };

    public LocationData(double lat, double lng, double distance, String unit) {
        this.lat = lat;
        this.lng = lng;
        this.distance = distance;
        this.unit = Unit.fromValue(unit);
    }

    public LocationData(Parcel in) {
        this.lat = in.readDouble();
        this.lng = in.readDouble();
        this.distance = in.readDouble();
        this.unit = Unit.fromValue(in.readString());
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeDouble(this.lat);
        dest.writeDouble(this.lng);
        dest.writeDouble(this.distance);
        dest.writeString(this.unit.getKey());
    }

    public double getLat() {
        return this.lat;
    }

    public double getLng() {
        return this.lng;
    }

    public double getDistance() {
        return this.distance;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public static enum Unit {
        METERS("meter"){

            @Override
            public double toFeet(double distance) {
                return distance * 3.28084;
            }

            @Override
            public double toKilometers(double distance) {
                return distance * 0.001;
            }

            @Override
            public double toMiles(double distance) {
                return distance * 6.21371E-4;
            }

            @Override
            public double toMeters(double distance) {
                return distance;
            }
        }
        ,
        FEET("feet"){

            @Override
            public double toMeters(double distance) {
                return distance * 0.3048000097536;
            }

            @Override
            public double toKilometers(double distance) {
                return distance * 3.048E-4;
            }

            @Override
            public double toMiles(double distance) {
                return distance * 1.89394E-4;
            }

            @Override
            public double toFeet(double distance) {
                return distance;
            }
        }
        ,
        KILOMETERS("kilometer"){

            @Override
            public double toMeters(double distance) {
                return distance * 1000.0;
            }

            @Override
            public double toFeet(double distance) {
                return distance * 3280.84;
            }

            @Override
            public double toMiles(double distance) {
                return distance * 0.6213712;
            }

            @Override
            public double toKilometers(double distance) {
                return distance;
            }
        }
        ,
        MILES("miles"){

            @Override
            public double toMeters(double distance) {
                return distance * 1609.34405;
            }

            @Override
            public double toFeet(double distance) {
                return distance * 5280.0;
            }

            @Override
            public double toKilometers(double distance) {
                return distance * 1.61;
            }

            @Override
            public double toMiles(double distance) {
                return distance;
            }
        };

        private final String key;

        private Unit(String value) {
            this.key = value;
        }

        public String getKey() {
            return this.key;
        }

        public static Unit fromValue(String value) {
            if (value == null) {
                return METERS;
            }
            for (Unit type : Unit.values()) {
                if (!type.getKey().equalsIgnoreCase(value)) continue;
                return type;
            }
            return METERS;
        }

        public abstract double toFeet(double var1);

        public abstract double toKilometers(double var1);

        public abstract double toMeters(double var1);

        public abstract double toMiles(double var1);
    }
}

