package com.flybits.android.kernel.db.caching;

import android.content.Context;

import com.flybits.android.kernel.db.KernelDatabase;
import com.flybits.android.kernel.models.Content;
import com.flybits.commons.library.caching.FlybitsUIListObserver;

/**
 * The {@code ContentCacheObserver} class is responsible for creating an {@code Observer} for
 * {@link Content} retrieved from the Flybits server and stored on the local SQLite DB using ROOM.
 * This {@code Observer} listens for {@link Content} changes and notifies the UI whenever a change
 * is detected. It will also trigger the retrieval of the initial {@link Content} object from the DB
 * in order to initialize the view.
 */
public class ContentCacheObserver extends FlybitsUIListObserver<Content> {

    private static ContentCacheObserver INSTANCE = null;

    private ContentCacheObserver(final Context context){
        new Thread(new Runnable() {
            public void run() {
                    setItems(KernelDatabase.getDatabase(context).contentDao().getLive());
                }
        }).start();
    }

    /**
     * As the {@code ContentCacheObserver} class acts as a {@code Singleton}, it is important to
     * initialize the {@code Singleton} with the proper attributes needed to function correctly.
     *
     * @param context The context of the application.
     * @return The instance of the {@code ContentCacheObserver} class which has either been
     * previously initialized or was initialized for the first time now.
     */
    public static ContentCacheObserver observe(Context context) {
        if (INSTANCE == null) {
            synchronized (ContentCacheObserver.class){
                if (INSTANCE == null){
                    INSTANCE = new ContentCacheObserver(context);
                }
            }
        }
        return INSTANCE;
    }

    @Override
    public void remove() {
        super.remove();
        if (getData() != null && !getData().hasActiveObservers()){
            INSTANCE = null;
        }
    }
}
