package com.flybits.android.kernel.reservedtemplates.survey.models;

import android.os.Parcel;

/**
 * This POJO defines the options a user can choose from in a {@code Question} when requesting the
 * data from a {@code SurveyQuestion} content instance.
 */

public class QuestionChoice extends Choice {

    public String value = "";

    public QuestionChoice(){}

    protected QuestionChoice(Parcel in) {
        super(in);
        value = in.readString();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeString(value);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<QuestionChoice> CREATOR = new Creator<QuestionChoice>() {
        @Override
        public QuestionChoice createFromParcel(Parcel in) {
            return new QuestionChoice(in);
        }

        @Override
        public QuestionChoice[] newArray(int size) {
            return new QuestionChoice[size];
        }
    };

}
