/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.context.plugins;

import android.app.ActivityManager;
import android.app.Notification;
import android.arch.persistence.room.ColumnInfo;
import android.arch.persistence.room.Entity;
import android.arch.persistence.room.Ignore;
import android.arch.persistence.room.PrimaryKey;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.content.ContextCompat;
import androidx.work.ExistingPeriodicWorkPolicy;
import androidx.work.ExistingWorkPolicy;
import androidx.work.OneTimeWorkRequest;
import androidx.work.PeriodicWorkRequest;
import androidx.work.WorkManager;
import androidx.work.WorkRequest;
import com.flybits.commons.library.logging.Displayer;
import com.flybits.commons.library.logging.Logger;
import com.flybits.context.ContextScope;
import com.flybits.context.ReservedContextPlugin;
import com.flybits.context.db.ContextDatabase;
import com.flybits.context.exceptions.InvalidContextPluginException;
import com.flybits.context.plugins.ContextPlugin;
import com.flybits.context.plugins.FlybitsContextPlugin$Builder$WhenMappings;
import com.flybits.context.plugins.activity.ActivityContextPluginService;
import com.flybits.context.plugins.battery.BatteryContextPluginService;
import com.flybits.context.plugins.battery.BatteryContextPluginWorker;
import com.flybits.context.plugins.beacon.BeaconScanningService;
import com.flybits.context.plugins.carrier.CarrierContextPluginService;
import com.flybits.context.plugins.carrier.CarrierContextPluginWorker;
import com.flybits.context.plugins.fitness.FitnessContextPluginService;
import com.flybits.context.plugins.fitness.FitnessContextPluginWorker;
import com.flybits.context.plugins.language.LanguageContextPluginService;
import com.flybits.context.plugins.language.LanguageContextPluginWorker;
import com.flybits.context.plugins.location.LocationContextPluginService;
import com.flybits.context.plugins.location.LocationContextPluginWorker;
import com.flybits.context.plugins.network.NetworkContextPluginService;
import com.flybits.context.plugins.network.NetworkContextPluginWorker;
import com.flybits.context.plugins.weather.WeatherContextPluginService;
import com.flybits.context.plugins.weather.WeatherContextPluginWorker;
import com.flybits.context.services.FlybitsContextPluginService;
import com.flybits.context.services.FlybitsContextPluginsWorker;
import com.flybits.context.utils.ContextUtilities;
import com.google.android.gms.gcm.GcmNetworkManager;
import com.google.android.gms.gcm.PeriodicTask;
import com.google.android.gms.gcm.Task;
import java.util.concurrent.TimeUnit;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.ResultKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\r\b\u0007\u0018\u0000 =2\u00020\u0001:\u0002<=B+\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b\u00a2\u0006\u0002\u0010\tB\u000f\b\u0012\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ'\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0010\u0010\u001f\u001a\f\u0012\u0006\b\u0001\u0012\u00020 \u0018\u00010\bH\u0000\u00a2\u0006\u0002\b!J'\u0010\"\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0010\u0010#\u001a\f\u0012\u0006\b\u0001\u0012\u00020$\u0018\u00010\bH\u0000\u00a2\u0006\u0002\b%J\u0010\u0010&\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010'\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020)H\u0002J\u0013\u0010*\u001a\u00020\u00062\b\u0010+\u001a\u0004\u0018\u00010,H\u0096\u0002J\b\u0010-\u001a\u00020\u0013H\u0002J\u0012\u0010.\u001a\f\u0012\u0006\b\u0001\u0012\u00020$\u0018\u00010\bH\u0007J\u0012\u0010/\u001a\f\u0012\u0006\b\u0001\u0012\u00020 \u0018\u00010\bH\u0002J\b\u00100\u001a\u000201H\u0016J\"\u00102\u001a\u00020\u00062\u0006\u00103\u001a\u00020\u001e2\u0010\u00104\u001a\f\u0012\u0006\b\u0001\u0012\u00020$\u0018\u00010\bH\u0002J\u0010\u00105\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u00106\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u00107\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u00108\u001a\u00020\u001cH\u0002J\u0010\u00109\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010:\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010;\u001a\u00020\u0013H\u0002R\u0014\u0010\r\u001a\u0004\u0018\u00010\u000e8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\b8\u0006@BX\u0087\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u00138\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u0004\u0018\u00010\u00158\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00068\u0006@BX\u0087\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0017R \u0010\u0004\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00038\u0006@BX\u0087\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00038\u0006@BX\u0087\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019\u00a8\u0006>"}, d2={"Lcom/flybits/context/plugins/FlybitsContextPlugin;", "Lcom/flybits/context/plugins/ContextPlugin;", "refreshTimeFlex", "", "refreshTime", "isRunning", "", "contextPluginRetriever", "Ljava/lang/Class;", "(JJZLjava/lang/Class;)V", "builder", "Lcom/flybits/context/plugins/FlybitsContextPlugin$Builder;", "(Lcom/flybits/context/plugins/FlybitsContextPlugin$Builder;)V", "contextDatabase", "Lcom/flybits/context/db/ContextDatabase;", "<set-?>", "getContextPluginRetriever", "()Ljava/lang/Class;", "extras", "Landroid/os/Bundle;", "foregroundServiceNotification", "Landroid/app/Notification;", "isCustomRefreshSet", "()Z", "getRefreshTime", "()J", "getRefreshTimeFlex", "cancelPluginServiceIfExists", "", "context", "Landroid/content/Context;", "worker", "Lcom/flybits/context/services/FlybitsContextPluginsWorker;", "cancelPluginServiceIfExists$context_release", "cancelPluginWorkerIfExists", "service", "Lcom/flybits/context/services/FlybitsContextPluginService;", "cancelPluginWorkerIfExists$context_release", "cancelService", "cancelWorkByName", "workerName", "", "equals", "other", "", "getExtras", "getService", "getWorker", "hashCode", "", "isServiceRunning", "mContext", "serviceClass", "onRefresh", "onStart", "onStop", "scheduleOneTimeWorkers", "scheduleService", "scheduleWorkers", "setBundle", "Builder", "Companion", "context_release"})
@Entity(tableName="flybits_context_plugin")
public final class FlybitsContextPlugin
implements ContextPlugin {
    @ColumnInfo(name="refresh_time_flex")
    private long refreshTimeFlex;
    @ColumnInfo(name="refresh_time")
    private long refreshTime;
    @ColumnInfo(name="running")
    private boolean isRunning;
    @Ignore
    private Notification foregroundServiceNotification;
    @Ignore
    private Bundle extras;
    @Ignore
    private ContextDatabase contextDatabase;
    @PrimaryKey
    @ColumnInfo(name="service")
    @NotNull
    private Class<?> contextPluginRetriever;
    @NotNull
    public static final String TABLE = "flybits_context_plugin";
    @NotNull
    public static final String COLUMN_REFRESH_TIME_FLEX = "refresh_time_flex";
    @NotNull
    public static final String COLUMN_REFRESH_TIME = "refresh_time";
    @NotNull
    public static final String COLUMN_SERVICE = "service";
    @NotNull
    public static final String COLUMN_IS_RUNNING = "running";
    @NotNull
    public static final String EXTRA_NOTIFICATION = "flybits_extra_notification";
    @NotNull
    public static final String EXTRA_MINIMUM_REFRESH_TIME = "flybits_minimum_refresh_time";
    public static final Companion Companion = new Companion(null);

    public final long getRefreshTimeFlex() {
        return this.refreshTimeFlex;
    }

    public final long getRefreshTime() {
        return this.refreshTime;
    }

    public final boolean isRunning() {
        return this.isRunning;
    }

    @NotNull
    public final Class<?> getContextPluginRetriever() {
        return this.contextPluginRetriever;
    }

    private final boolean isCustomRefreshSet() {
        return this.refreshTime < (long)60;
    }

    public boolean equals(@Nullable Object other) {
        boolean bl;
        if (!(other instanceof FlybitsContextPlugin)) {
            return false;
        }
        FlybitsContextPlugin another = (FlybitsContextPlugin)other;
        Class<?> clazz = another.contextPluginRetriever;
        if (Intrinsics.areEqual(clazz != null ? clazz.getSuperclass() : null, FlybitsContextPluginsWorker.class)) {
            Class<? extends FlybitsContextPluginsWorker> clazz2 = this.getWorker();
            bl = Intrinsics.areEqual((Object)another.contextPluginRetriever.getSimpleName(), (Object)(clazz2 != null ? clazz2.getSimpleName() : null));
        } else {
            Class<?> clazz3 = another.contextPluginRetriever;
            Class<? extends FlybitsContextPluginService> clazz4 = this.getService();
            bl = Intrinsics.areEqual((Object)(clazz3 != null ? clazz3.getSimpleName() : null), (Object)(clazz4 != null ? clazz4.getSimpleName() : null));
        }
        return bl;
    }

    private final Bundle getExtras() {
        Bundle bundle = this.extras;
        if (bundle == null) {
            Bundle bundle2 = Bundle.EMPTY;
            bundle = bundle2;
            Intrinsics.checkExpressionValueIsNotNull((Object)bundle2, (String)"Bundle.EMPTY");
        }
        return bundle;
    }

    private final Class<? extends FlybitsContextPluginsWorker> getWorker() {
        Class<?> clazz;
        if (FlybitsContextPlugin.Companion.isWorkerClass(this.contextPluginRetriever)) {
            clazz = this.contextPluginRetriever;
            if (clazz == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.Class<out com.flybits.context.services.FlybitsContextPluginsWorker>");
            }
        } else {
            clazz = null;
        }
        return clazz;
    }

    @Deprecated(message="Using this function to get the Service for a Plugin is Deprecated, Instead use Worker for the periodic task.Replace with getWorker() to get the [FlybitsContextPluginsWorker] for plugin [FlybitsContextPlugin].deprecated in version 1.19.0, will be removed in version 3.0.0", replaceWith=@ReplaceWith(imports={}, expression="getWorker()"))
    @Nullable
    public final Class<? extends FlybitsContextPluginService> getService() {
        Class<?> clazz;
        if (FlybitsContextPlugin.Companion.isServiceClass(this.contextPluginRetriever)) {
            clazz = this.contextPluginRetriever;
            if (clazz == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.Class<out com.flybits.context.services.FlybitsContextPluginService>");
            }
        } else {
            clazz = null;
        }
        return clazz;
    }

    @Override
    public void onStart(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (FlybitsContextPlugin.Companion.isWorkerClass(this.contextPluginRetriever)) {
            this.scheduleWorkers(context);
        } else {
            this.scheduleService(context);
        }
    }

    @Override
    public void onStop(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Logger.appendTag((String)"ContextPlugin").d("onStop(): " + this.contextPluginRetriever.getName().toString());
        if (FlybitsContextPlugin.Companion.isServiceClass(this.contextPluginRetriever)) {
            this.cancelService(context);
        } else if (FlybitsContextPlugin.Companion.isWorkerClass(this.contextPluginRetriever)) {
            String string = this.contextPluginRetriever.getSimpleName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"contextPluginRetriever.simpleName");
            this.cancelWorkByName(string);
        }
    }

    @Override
    public void onRefresh(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (FlybitsContextPlugin.Companion.isWorkerClass(this.contextPluginRetriever)) {
            this.scheduleOneTimeWorkers();
        } else if (FlybitsContextPlugin.Companion.isServiceClass(this.contextPluginRetriever)) {
            this.scheduleService(context);
        }
    }

    private final void scheduleService(Context context) {
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getDefault())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, context, null){
            private CoroutineScope p$;
            int label;
            final /* synthetic */ FlybitsContextPlugin this$0;
            final /* synthetic */ Context $context;

            @Nullable
            public final Object invokeSuspend(@NotNull Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        CoroutineScope $this$launch = this.p$;
                        this.this$0.cancelPluginWorkerIfExists$context_release(this.$context, this.this$0.getService());
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.this$0 = flybitsContextPlugin;
                this.$context = context;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        if (this.isCustomRefreshSet()) {
            Class<? extends FlybitsContextPluginService> clazz = this.getService();
            if (clazz == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.Class<out com.flybits.context.services.FlybitsContextPluginService>");
            }
            if (!this.isServiceRunning(context, clazz) && this.foregroundServiceNotification != null) {
                Intent intent = new Intent(context, this.getService());
                Bundle extras = this.setBundle();
                extras.putParcelable(EXTRA_NOTIFICATION, (Parcelable)this.foregroundServiceNotification);
                intent.putExtras(extras);
                ContextCompat.startForegroundService((Context)context, (Intent)intent);
                this.isRunning = true;
            }
        } else {
            SharedPreferences.Editor editor = ContextScope.getContextPreferences(context).edit();
            Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"ContextScope.getContextPreferences(context).edit()");
            SharedPreferences.Editor preferences = editor;
            preferences.putLong(Companion.getPrefName(this.contextPluginRetriever), this.refreshTime);
            preferences.apply();
            GcmNetworkManager mGcmNetworkManager = GcmNetworkManager.getInstance((Context)context);
            Class<? extends FlybitsContextPluginService> clazz = this.getService();
            PeriodicTask.Builder task = new PeriodicTask.Builder().setTag(clazz != null ? clazz.getSimpleName() : null).setExtras(this.setBundle()).setPeriod(this.refreshTime).setUpdateCurrent(true).setPersisted(true).setFlex(this.refreshTimeFlex).setRequiredNetwork(2).setService(this.getService());
            mGcmNetworkManager.schedule((Task)task.build());
            this.isRunning = true;
        }
    }

    private final void cancelService(Context context) {
        if (this.isCustomRefreshSet()) {
            if (this.isServiceRunning(context, this.getService())) {
                Intent intent = new Intent(context, this.getService());
                context.stopService(intent);
            }
        } else {
            Intent intent = new Intent(context, this.getService());
            if (ContextUtilities.isServiceDefined(context, intent)) {
                GcmNetworkManager mGcmNetworkManager = GcmNetworkManager.getInstance((Context)context);
                try {
                    Class<? extends FlybitsContextPluginService> clazz = this.getService();
                    mGcmNetworkManager.cancelTask(clazz != null ? clazz.getSimpleName() : null, this.getService());
                }
                catch (IllegalArgumentException ex) {
                    Logger.exception((String)"FlybitsContextPlugin.stop", (Exception)ex);
                }
            }
        }
        this.isRunning = false;
    }

    private final boolean isServiceRunning(Context mContext, Class<? extends FlybitsContextPluginService> serviceClass) {
        Object activityManager = mContext.getSystemService("activity");
        if (activityManager instanceof ActivityManager) {
            for (ActivityManager.RunningServiceInfo service : ((ActivityManager)activityManager).getRunningServices(Integer.MAX_VALUE)) {
                Class<? extends FlybitsContextPluginService> clazz = serviceClass;
                String string = clazz != null ? clazz.getName() : null;
                ComponentName componentName = service.service;
                Intrinsics.checkExpressionValueIsNotNull((Object)componentName, (String)"service.service");
                if (!Intrinsics.areEqual((Object)string, (Object)componentName.getClassName())) continue;
                Logger.appendTag((String)"ContextPlugin").d("unregisterUploadingContext Completed");
                Displayer displayer = Logger.appendTag((String)"ContextPlugin");
                StringBuilder stringBuilder = new StringBuilder().append("isServiceRunning: ");
                ComponentName componentName2 = service.service;
                Intrinsics.checkExpressionValueIsNotNull((Object)componentName2, (String)"service.service");
                displayer.d(stringBuilder.append(componentName2.getClassName()).append(", true").toString());
                return true;
            }
        }
        Class<? extends FlybitsContextPluginService> clazz = serviceClass;
        Logger.appendTag((String)"ContextPlugin").d("isServiceRunning: " + (clazz != null ? clazz.getName() : null) + ", false");
        return false;
    }

    private final void scheduleWorkers(Context context) {
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getDefault())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, context, null){
            private CoroutineScope p$;
            int label;
            final /* synthetic */ FlybitsContextPlugin this$0;
            final /* synthetic */ Context $context;

            @Nullable
            public final Object invokeSuspend(@NotNull Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        CoroutineScope $this$launch = this.p$;
                        this.this$0.cancelPluginServiceIfExists$context_release(this.$context, FlybitsContextPlugin.access$getWorker(this.this$0));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.this$0 = flybitsContextPlugin;
                this.$context = context;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        this.scheduleOneTimeWorkers();
        Class<? extends FlybitsContextPluginsWorker> clazz = this.getWorker();
        if (clazz != null) {
            Class<? extends FlybitsContextPluginsWorker> clazz2 = clazz;
            boolean bl = false;
            boolean bl2 = false;
            Class<? extends FlybitsContextPluginsWorker> worker = clazz2;
            boolean bl3 = false;
            WorkRequest workRequest = new PeriodicWorkRequest.Builder(worker, this.refreshTime, TimeUnit.SECONDS, this.refreshTimeFlex, TimeUnit.SECONDS).build();
            Intrinsics.checkExpressionValueIsNotNull((Object)workRequest, (String)"PeriodicWorkRequest\n    \u2026\n                .build()");
            PeriodicWorkRequest workRequest2 = (PeriodicWorkRequest)workRequest;
            WorkManager.getInstance().enqueueUniquePeriodicWork(worker.getSimpleName(), ExistingPeriodicWorkPolicy.REPLACE, workRequest2);
            this.isRunning = true;
        } else {
            Logger.appendTag((String)"ContextPlugin").e("Error Scheduling the Worker Request");
        }
    }

    private final void scheduleOneTimeWorkers() {
        Class<? extends FlybitsContextPluginsWorker> clazz = this.getWorker();
        if (clazz != null) {
            Class<? extends FlybitsContextPluginsWorker> clazz2 = clazz;
            boolean bl = false;
            boolean bl2 = false;
            Class<? extends FlybitsContextPluginsWorker> worker = clazz2;
            boolean bl3 = false;
            WorkRequest workRequest = new OneTimeWorkRequest.Builder(worker).build();
            Intrinsics.checkExpressionValueIsNotNull((Object)workRequest, (String)"OneTimeWorkRequest\n     \u2026\n                .build()");
            OneTimeWorkRequest workRequest2 = (OneTimeWorkRequest)workRequest;
            String oneTimeWorkerName = worker.getSimpleName() + "_OneTimeWorker";
            WorkManager.getInstance().enqueueUniqueWork(oneTimeWorkerName, ExistingWorkPolicy.REPLACE, workRequest2);
            this.isRunning = true;
        } else {
            Logger.appendTag((String)"ContextPlugin").e("Error Scheduling the Worker Request");
        }
    }

    public final void cancelPluginServiceIfExists$context_release(@NotNull Context context, @Nullable Class<? extends FlybitsContextPluginsWorker> worker) {
        block16: {
            FlybitsContextPlugin flybitsContextPlugin;
            boolean bl;
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            this.contextDatabase = ContextDatabase.Companion.getDatabase(context);
            String servicePath = "";
            boolean isValidWorker = false;
            Class<? extends FlybitsContextPluginsWorker> clazz = worker;
            if (Intrinsics.areEqual(clazz, BatteryContextPluginWorker.class)) {
                String string = BatteryContextPluginService.class.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"BatteryContextPluginService::class.java.name");
                servicePath = string;
                bl = true;
            } else if (Intrinsics.areEqual(clazz, LocationContextPluginWorker.class)) {
                String string = LocationContextPluginService.class.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"LocationContextPluginService::class.java.name");
                servicePath = string;
                bl = true;
            } else if (Intrinsics.areEqual(clazz, NetworkContextPluginWorker.class)) {
                String string = NetworkContextPluginService.class.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"NetworkContextPluginService::class.java.name");
                servicePath = string;
                bl = true;
            } else if (Intrinsics.areEqual(clazz, LanguageContextPluginWorker.class)) {
                String string = LanguageContextPluginService.class.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"LanguageContextPluginService::class.java.name");
                servicePath = string;
                bl = true;
            } else if (Intrinsics.areEqual(clazz, CarrierContextPluginWorker.class)) {
                String string = CarrierContextPluginService.class.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"CarrierContextPluginService::class.java.name");
                servicePath = string;
                bl = true;
            } else if (Intrinsics.areEqual(clazz, FitnessContextPluginWorker.class)) {
                String string = FitnessContextPluginService.class.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"FitnessContextPluginService::class.java.name");
                servicePath = string;
                bl = true;
            } else if (Intrinsics.areEqual(clazz, WeatherContextPluginWorker.class)) {
                String string = WeatherContextPluginService.class.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"WeatherContextPluginService::class.java.name");
                servicePath = string;
                bl = true;
            } else {
                bl = isValidWorker = false;
            }
            if (!isValidWorker) break block16;
            Object object = this.contextDatabase;
            FlybitsContextPlugin flybitsContextPlugin2 = object != null && (object = object.flybitsContextPluginDAO()) != null ? object.getSingle(servicePath) : (flybitsContextPlugin = null);
            if (flybitsContextPlugin != null) {
                flybitsContextPlugin.onStop(context);
                Object object2 = this.contextDatabase;
                if (object2 != null && (object2 = object2.flybitsContextPluginDAO()) != null) {
                    object2.delete(flybitsContextPlugin);
                }
            }
        }
    }

    public final void cancelPluginWorkerIfExists$context_release(@NotNull Context context, @Nullable Class<? extends FlybitsContextPluginService> service) {
        block16: {
            FlybitsContextPlugin flybitsContextPlugin;
            boolean bl;
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            this.contextDatabase = ContextDatabase.Companion.getDatabase(context);
            String workerPath = "";
            boolean isValidService = false;
            Class<? extends FlybitsContextPluginService> clazz = service;
            if (Intrinsics.areEqual(clazz, BatteryContextPluginService.class)) {
                String string = BatteryContextPluginWorker.class.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"BatteryContextPluginWorker::class.java.name");
                workerPath = string;
                bl = true;
            } else if (Intrinsics.areEqual(clazz, LocationContextPluginService.class)) {
                String string = LocationContextPluginWorker.class.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"LocationContextPluginWorker::class.java.name");
                workerPath = string;
                bl = true;
            } else if (Intrinsics.areEqual(clazz, NetworkContextPluginService.class)) {
                String string = NetworkContextPluginWorker.class.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"NetworkContextPluginWorker::class.java.name");
                workerPath = string;
                bl = true;
            } else if (Intrinsics.areEqual(clazz, LanguageContextPluginService.class)) {
                String string = LanguageContextPluginWorker.class.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"LanguageContextPluginWorker::class.java.name");
                workerPath = string;
                bl = true;
            } else if (Intrinsics.areEqual(clazz, CarrierContextPluginService.class)) {
                String string = CarrierContextPluginWorker.class.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"CarrierContextPluginWorker::class.java.name");
                workerPath = string;
                bl = true;
            } else if (Intrinsics.areEqual(clazz, FitnessContextPluginService.class)) {
                String string = FitnessContextPluginWorker.class.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"FitnessContextPluginWorker::class.java.name");
                workerPath = string;
                bl = true;
            } else if (Intrinsics.areEqual(clazz, WeatherContextPluginService.class)) {
                String string = WeatherContextPluginWorker.class.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"WeatherContextPluginWorker::class.java.name");
                workerPath = string;
                bl = true;
            } else {
                bl = isValidService = false;
            }
            if (!isValidService) break block16;
            Object object = this.contextDatabase;
            FlybitsContextPlugin flybitsContextPlugin2 = object != null && (object = object.flybitsContextPluginDAO()) != null ? object.getSingle(workerPath) : (flybitsContextPlugin = null);
            if (flybitsContextPlugin != null) {
                flybitsContextPlugin.onStop(context);
                Object object2 = this.contextDatabase;
                if (object2 != null && (object2 = object2.flybitsContextPluginDAO()) != null) {
                    object2.delete(flybitsContextPlugin);
                }
            }
        }
    }

    private final void cancelWorkByName(String workerName) {
        WorkManager.getInstance().cancelUniqueWork(workerName);
        this.isRunning = false;
    }

    private final Bundle setBundle() {
        Bundle bundle = Intrinsics.areEqual((Object)this.getExtras(), (Object)Bundle.EMPTY) ? new Bundle() : this.getExtras();
        bundle.putLong(EXTRA_MINIMUM_REFRESH_TIME, this.refreshTime);
        return bundle;
    }

    public int hashCode() {
        int result = Long.hashCode(this.refreshTimeFlex);
        result = 31 * result + Long.hashCode(this.refreshTime);
        result = 31 * result + Boolean.hashCode(this.isRunning);
        Notification notification = this.foregroundServiceNotification;
        result = 31 * result + (notification != null ? notification.hashCode() : 0);
        Bundle bundle = this.extras;
        result = 31 * result + (bundle != null ? bundle.hashCode() : 0);
        result = 31 * result + this.contextPluginRetriever.hashCode();
        return result;
    }

    public FlybitsContextPlugin(long refreshTimeFlex, long refreshTime, boolean isRunning, @NotNull Class<?> contextPluginRetriever) {
        Intrinsics.checkParameterIsNotNull(contextPluginRetriever, (String)"contextPluginRetriever");
        this.refreshTimeFlex = refreshTimeFlex;
        this.refreshTime = refreshTime;
        this.isRunning = isRunning;
        this.contextPluginRetriever = contextPluginRetriever;
    }

    private FlybitsContextPlugin(Builder builder) {
        Class<Object> clazz;
        if (builder.getExtras$context_release() != null) {
            this.extras = builder.getExtras$context_release();
        }
        if (builder.isWorker$context_release()) {
            clazz = builder.getTaskWorker$context_release();
            if (clazz == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.Class<out com.flybits.context.services.FlybitsContextPluginsWorker>");
            }
        } else {
            clazz = builder.getTaskService$context_release();
            if (clazz == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.Class<out com.flybits.context.services.FlybitsContextPluginService>");
            }
        }
        this.contextPluginRetriever = clazz;
        this.refreshTimeFlex = builder.getTimeInSecondsFlex$context_release();
        this.refreshTime = builder.getTimeInSeconds$context_release();
        this.foregroundServiceNotification = builder.getForegroundServiceNotification$context_release();
        boolean bl = this.refreshTime == (long)builder.getBEACON_UNIQUE_ID$context_release() || this.refreshTime >= (long)60 || this.foregroundServiceNotification != null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "foregroundServiceNotification cannot be null if refresh time is less than 60 seconds. Use Builder.setForegroundServiceNotification().";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        bl = this.refreshTime != (long)builder.getBEACON_UNIQUE_ID$context_release() || this.foregroundServiceNotification != null;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "You are attempting to initialize the Beacon plugin. In order to do this you must pass a foreground notification using the Builder.setForegroundServiceNotification() method.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    public /* synthetic */ FlybitsContextPlugin(Builder builder, DefaultConstructorMarker $constructor_marker) {
        this(builder);
    }

    public static final /* synthetic */ Class access$getWorker(FlybitsContextPlugin $this) {
        return $this.getWorker();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0017\b\u0017\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005B!\b\u0016\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB\u000f\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rB\u0017\b\u0017\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000eJ\u0010\u00103\u001a\u0002042\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u00105\u001a\u0002042\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0006\u00106\u001a\u000207J\u000e\u00108\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0014J\u0018\u00109\u001a\u0002042\u0006\u0010:\u001a\u00020+2\u0006\u0010;\u001a\u00020<H\u0002J\u000e\u0010=\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001aJ\u001e\u0010>\u001a\u00020\u00002\u0006\u0010?\u001a\u00020+2\u0006\u0010:\u001a\u00020+2\u0006\u0010;\u001a\u00020<J\u0018\u0010@\u001a\u0002042\u0006\u0010?\u001a\u00020+2\u0006\u0010;\u001a\u00020<H\u0002J\u0018\u0010A\u001a\u0002042\u000e\u0010B\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003H\u0002J\u0018\u0010C\u001a\u0002042\u000e\u0010D\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0003H\u0002R\u0014\u0010\u000f\u001a\u00020\u0010X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\b\u001a\u00020\tX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R$\u0010#\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0004\u0018\u00010\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010\u0005R$\u0010'\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0007\u0018\u00010\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010%\"\u0004\b)\u0010\u0005R\u001a\u0010*\u001a\u00020+X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u001a\u00100\u001a\u00020+X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010-\"\u0004\b2\u0010/\u00a8\u0006E"}, d2={"Lcom/flybits/context/plugins/FlybitsContextPlugin$Builder;", "", "serviceClass", "Ljava/lang/Class;", "Lcom/flybits/context/services/FlybitsContextPluginService;", "(Ljava/lang/Class;)V", "workerClass", "Lcom/flybits/context/services/FlybitsContextPluginsWorker;", "isWorker", "", "(Ljava/lang/Class;Z)V", "plugin", "Lcom/flybits/context/ReservedContextPlugin;", "(Lcom/flybits/context/ReservedContextPlugin;)V", "(Lcom/flybits/context/ReservedContextPlugin;Z)V", "BEACON_UNIQUE_ID", "", "getBEACON_UNIQUE_ID$context_release", "()I", "extras", "Landroid/os/Bundle;", "getExtras$context_release", "()Landroid/os/Bundle;", "setExtras$context_release", "(Landroid/os/Bundle;)V", "foregroundServiceNotification", "Landroid/app/Notification;", "getForegroundServiceNotification$context_release", "()Landroid/app/Notification;", "setForegroundServiceNotification$context_release", "(Landroid/app/Notification;)V", "isWorker$context_release", "()Z", "setWorker$context_release", "(Z)V", "taskService", "getTaskService$context_release", "()Ljava/lang/Class;", "setTaskService$context_release", "taskWorker", "getTaskWorker$context_release", "setTaskWorker$context_release", "timeInSeconds", "", "getTimeInSeconds$context_release", "()J", "setTimeInSeconds$context_release", "(J)V", "timeInSecondsFlex", "getTimeInSecondsFlex$context_release", "setTimeInSecondsFlex$context_release", "assignService", "", "assignWorker", "build", "Lcom/flybits/context/plugins/FlybitsContextPlugin;", "setExtras", "setFlexTimeForWorker", "flexTime", "unit", "Ljava/util/concurrent/TimeUnit;", "setForegroundServiceNotification", "setRefreshTime", "time", "setRefreshTimeForWorker", "setService", "service", "setWorker", "worker", "context_release"})
    public static final class Builder {
        private long timeInSeconds;
        @Nullable
        private Notification foregroundServiceNotification;
        private long timeInSecondsFlex;
        @Nullable
        private Bundle extras;
        private final int BEACON_UNIQUE_ID = -99;
        @Nullable
        private Class<? extends FlybitsContextPluginsWorker> taskWorker;
        @Nullable
        private Class<? extends FlybitsContextPluginService> taskService;
        private boolean isWorker;

        public final long getTimeInSeconds$context_release() {
            return this.timeInSeconds;
        }

        public final void setTimeInSeconds$context_release(long l) {
            this.timeInSeconds = l;
        }

        @Nullable
        public final Notification getForegroundServiceNotification$context_release() {
            return this.foregroundServiceNotification;
        }

        public final void setForegroundServiceNotification$context_release(@Nullable Notification notification) {
            this.foregroundServiceNotification = notification;
        }

        public final long getTimeInSecondsFlex$context_release() {
            return this.timeInSecondsFlex;
        }

        public final void setTimeInSecondsFlex$context_release(long l) {
            this.timeInSecondsFlex = l;
        }

        @Nullable
        public final Bundle getExtras$context_release() {
            return this.extras;
        }

        public final void setExtras$context_release(@Nullable Bundle bundle) {
            this.extras = bundle;
        }

        public final int getBEACON_UNIQUE_ID$context_release() {
            return this.BEACON_UNIQUE_ID;
        }

        @Nullable
        public final Class<? extends FlybitsContextPluginsWorker> getTaskWorker$context_release() {
            return this.taskWorker;
        }

        public final void setTaskWorker$context_release(@Nullable Class<? extends FlybitsContextPluginsWorker> clazz) {
            this.taskWorker = clazz;
        }

        @Nullable
        public final Class<? extends FlybitsContextPluginService> getTaskService$context_release() {
            return this.taskService;
        }

        public final void setTaskService$context_release(@Nullable Class<? extends FlybitsContextPluginService> clazz) {
            this.taskService = clazz;
        }

        public final boolean isWorker$context_release() {
            return this.isWorker;
        }

        public final void setWorker$context_release(boolean bl) {
            this.isWorker = bl;
        }

        private final void assignWorker(ReservedContextPlugin plugin) {
            switch (FlybitsContextPlugin$Builder$WhenMappings.$EnumSwitchMapping$0[plugin.ordinal()]) {
                case 1: {
                    this.setWorker(BatteryContextPluginWorker.class);
                    break;
                }
                case 2: {
                    this.setWorker(LocationContextPluginWorker.class);
                    break;
                }
                case 3: {
                    this.setWorker(CarrierContextPluginWorker.class);
                    break;
                }
                case 4: {
                    this.setWorker(WeatherContextPluginWorker.class);
                    break;
                }
                case 5: {
                    this.setWorker(NetworkContextPluginWorker.class);
                    break;
                }
                case 6: {
                    this.isWorker = false;
                    this.timeInSeconds = 60L;
                    this.timeInSecondsFlex = 60L;
                    this.setService(ActivityContextPluginService.class);
                    break;
                }
                case 7: {
                    this.setWorker(LanguageContextPluginWorker.class);
                    break;
                }
                case 8: {
                    this.setWorker(FitnessContextPluginWorker.class);
                    break;
                }
                case 9: {
                    this.isWorker = false;
                    this.timeInSeconds = this.BEACON_UNIQUE_ID;
                    this.timeInSecondsFlex = 60L;
                    this.setService(BeaconScanningService.class);
                    break;
                }
                default: {
                    Logger.appendTag((String)"ContextPlugin").d("Worker for this Plugin Not Available");
                }
            }
        }

        private final void assignService(ReservedContextPlugin plugin) {
            switch (FlybitsContextPlugin$Builder$WhenMappings.$EnumSwitchMapping$1[plugin.ordinal()]) {
                case 1: {
                    this.setService(BatteryContextPluginService.class);
                    break;
                }
                case 2: {
                    this.setService(CarrierContextPluginService.class);
                    break;
                }
                case 3: {
                    this.setService(LocationContextPluginService.class);
                    break;
                }
                case 4: {
                    this.setService(WeatherContextPluginService.class);
                    break;
                }
                case 5: {
                    this.setService(NetworkContextPluginService.class);
                    break;
                }
                case 6: {
                    this.setService(ActivityContextPluginService.class);
                    break;
                }
                case 7: {
                    this.setService(LanguageContextPluginService.class);
                    break;
                }
                case 8: {
                    this.setService(FitnessContextPluginService.class);
                    break;
                }
                case 9: {
                    this.setService(BeaconScanningService.class);
                    this.timeInSeconds = this.BEACON_UNIQUE_ID;
                    break;
                }
                default: {
                    Logger.appendTag((String)"ContextPlugin").d("Invalid Plugin");
                }
            }
        }

        @NotNull
        public final FlybitsContextPlugin build() throws InvalidContextPluginException {
            if (this.timeInSeconds == 0L) {
                this.timeInSeconds = 60L;
            }
            if (this.timeInSecondsFlex == 0L) {
                this.timeInSecondsFlex = 60L;
            }
            if (this.isWorker) {
                this.timeInSeconds = 900L;
                this.timeInSecondsFlex = 300L;
                Logger.appendTag((String)"ContextPlugin").d("worker build");
            } else {
                Logger.appendTag((String)"ContextPlugin").d("service build");
            }
            return new FlybitsContextPlugin(this, null);
        }

        @NotNull
        public final Builder setExtras(@NotNull Bundle extras) {
            Intrinsics.checkParameterIsNotNull((Object)extras, (String)"extras");
            this.extras = extras;
            return this;
        }

        @NotNull
        public final Builder setRefreshTime(long time, long flexTime, @NotNull TimeUnit unit) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)unit), (String)"unit");
            if (this.timeInSeconds != (long)this.BEACON_UNIQUE_ID) {
                if (this.isWorker) {
                    this.setRefreshTimeForWorker(time, unit);
                    this.setFlexTimeForWorker(flexTime, unit);
                } else {
                    this.timeInSeconds = unit.toSeconds(time);
                    this.timeInSecondsFlex = unit.toSeconds(flexTime);
                }
            }
            return this;
        }

        private final void setRefreshTimeForWorker(long time, TimeUnit unit) {
            long l = time;
            boolean bl = false;
            boolean bl2 = false;
            long it = l;
            boolean bl3 = false;
            switch (FlybitsContextPlugin$Builder$WhenMappings.$EnumSwitchMapping$2[unit.ordinal()]) {
                case 1: {
                    if (it < (long)900) {
                        this.timeInSeconds = unit.toSeconds(900L);
                        break;
                    }
                    this.timeInSeconds = unit.toSeconds(it);
                    break;
                }
                case 2: {
                    if (it < (long)15) {
                        this.timeInSeconds = unit.toSeconds(15L);
                        break;
                    }
                    this.timeInSeconds = unit.toSeconds(it);
                    break;
                }
                case 3: {
                    if (it < (long)900000) {
                        this.timeInSeconds = unit.toSeconds(900000L);
                        break;
                    }
                    this.timeInSeconds = unit.toSeconds(it);
                    break;
                }
                default: {
                    this.timeInSeconds = unit.toSeconds(time);
                }
            }
        }

        private final void setFlexTimeForWorker(long flexTime, TimeUnit unit) {
            long l = flexTime;
            boolean bl = false;
            boolean bl2 = false;
            long it = l;
            boolean bl3 = false;
            switch (FlybitsContextPlugin$Builder$WhenMappings.$EnumSwitchMapping$3[unit.ordinal()]) {
                case 1: {
                    if (it < (long)300) {
                        this.timeInSecondsFlex = unit.toSeconds(300L);
                        break;
                    }
                    this.timeInSecondsFlex = unit.toSeconds(it);
                    break;
                }
                case 2: {
                    if (it < (long)5) {
                        this.timeInSecondsFlex = unit.toSeconds(5L);
                        break;
                    }
                    this.timeInSecondsFlex = unit.toSeconds(it);
                    break;
                }
                case 3: {
                    if (it < (long)300000) {
                        this.timeInSecondsFlex = unit.toSeconds(300000L);
                        break;
                    }
                    this.timeInSecondsFlex = unit.toSeconds(it);
                    break;
                }
                default: {
                    this.timeInSecondsFlex = unit.toSeconds(flexTime);
                }
            }
        }

        @NotNull
        public final Builder setForegroundServiceNotification(@NotNull Notification foregroundServiceNotification) {
            Intrinsics.checkParameterIsNotNull((Object)foregroundServiceNotification, (String)"foregroundServiceNotification");
            this.foregroundServiceNotification = foregroundServiceNotification;
            return this;
        }

        private final void setWorker(Class<? extends FlybitsContextPluginsWorker> worker) {
            this.isWorker = true;
            this.taskWorker = worker;
        }

        private final void setService(Class<? extends FlybitsContextPluginService> service) {
            this.isWorker = false;
            this.taskService = service;
        }

        @Deprecated(message="Using this constructor to specify Service for a Plugin is Deprecated, Instead provide the Class which extends a Worker [FlybitsContextPluginsWorker] as the parameter.deprecated in version 1.19.0, will be removed in version 3.0.0", replaceWith=@ReplaceWith(imports={}, expression="[FlybitsContextPlugin.Builder(FlybitsContextPluginsWorker)]"))
        public Builder(@NotNull Class<? extends FlybitsContextPluginService> serviceClass) {
            Intrinsics.checkParameterIsNotNull(serviceClass, (String)"serviceClass");
            this.timeInSeconds = 60L;
            this.timeInSecondsFlex = 60L;
            this.BEACON_UNIQUE_ID = -99;
            this.setService(serviceClass);
        }

        public Builder(@NotNull Class<? extends FlybitsContextPluginsWorker> workerClass, boolean isWorker) {
            Intrinsics.checkParameterIsNotNull(workerClass, (String)"workerClass");
            this.timeInSeconds = 60L;
            this.timeInSecondsFlex = 60L;
            this.BEACON_UNIQUE_ID = -99;
            if (isWorker) {
                this.setWorker(workerClass);
            }
        }

        public /* synthetic */ Builder(Class clazz, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = true;
            }
            this(clazz, bl);
        }

        public Builder(@NotNull ReservedContextPlugin plugin) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)plugin), (String)"plugin");
            this.timeInSeconds = 60L;
            this.timeInSecondsFlex = 60L;
            this.BEACON_UNIQUE_ID = -99;
            this.assignWorker(plugin);
        }

        @Deprecated(message="Using this constructor to assign Service for a Plugin is Deprecated, Instead provide the Class which extends a Worker [FlybitsContextPluginsWorker] as the parameter.deprecated in version 1.19.0, will be removed in version 3.0.0", replaceWith=@ReplaceWith(imports={}, expression="[FlybitsContextPlugin.Builder(ReservedContextPlugin.PLUGIN)]"))
        public Builder(@NotNull ReservedContextPlugin plugin, boolean isWorker) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)plugin), (String)"plugin");
            this.timeInSeconds = 60L;
            this.timeInSecondsFlex = 60L;
            this.BEACON_UNIQUE_ID = -99;
            if (isWorker) {
                this.assignWorker(plugin);
            } else if (!isWorker) {
                this.assignService(plugin);
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0000\u00a2\u0006\u0002\b\u0010J\u0012\u0010\u0011\u001a\u00020\u00042\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u000eJ\u0014\u0010\u0013\u001a\u00020\f2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0002J\u0014\u0010\u0014\u001a\u00020\f2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/flybits/context/plugins/FlybitsContextPlugin$Companion;", "", "()V", "COLUMN_IS_RUNNING", "", "COLUMN_REFRESH_TIME", "COLUMN_REFRESH_TIME_FLEX", "COLUMN_SERVICE", "EXTRA_MINIMUM_REFRESH_TIME", "EXTRA_NOTIFICATION", "TABLE", "checkClass", "", "classLookup", "Ljava/lang/Class;", "contextPluginRetriever", "checkClass$context_release", "getPrefName", "classToBeSaved", "isServiceClass", "isWorkerClass", "context_release"})
    public static final class Companion {
        @NotNull
        public final String getPrefName(@NotNull Class<?> classToBeSaved) {
            Intrinsics.checkParameterIsNotNull(classToBeSaved, (String)"classToBeSaved");
            return "ContextPlugin-" + classToBeSaved.getSimpleName();
        }

        private final boolean isWorkerClass(Class<?> contextPluginRetriever) {
            return this.checkClass$context_release(FlybitsContextPluginsWorker.class, contextPluginRetriever);
        }

        private final boolean isServiceClass(Class<?> contextPluginRetriever) {
            return this.checkClass$context_release(FlybitsContextPluginService.class, contextPluginRetriever);
        }

        public final boolean checkClass$context_release(@NotNull Class<?> classLookup, @NotNull Class<?> contextPluginRetriever) {
            boolean bl;
            Intrinsics.checkParameterIsNotNull(classLookup, (String)"classLookup");
            Intrinsics.checkParameterIsNotNull(contextPluginRetriever, (String)"contextPluginRetriever");
            if (contextPluginRetriever.getSuperclass() == null) {
                return false;
            }
            if (Intrinsics.areEqual(contextPluginRetriever.getSuperclass(), classLookup)) {
                bl = true;
            } else {
                Class<?> clazz = contextPluginRetriever.getSuperclass();
                if (clazz == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.Class<*>");
                }
                bl = this.checkClass$context_release(classLookup, clazz);
            }
            return bl;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

