/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.context.models.internal;

import android.arch.persistence.room.ColumnInfo;
import android.arch.persistence.room.Entity;
import android.arch.persistence.room.Ignore;
import android.arch.persistence.room.PrimaryKey;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.flybits.commons.library.api.FlyAway;
import com.flybits.commons.library.api.results.callbacks.PagedResultCallback;
import com.flybits.commons.library.deserializations.IDeserializer;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.models.internal.QueryParameters;
import com.flybits.commons.library.models.internal.Result;
import com.flybits.context.deserializations.DeserializeContextPlugins;
import com.flybits.context.models.results.ContextPluginResult;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

@Entity(tableName="plugin")
public class Plugin {
    public static final String API = "/context/ctxschema/contextplugins";
    @PrimaryKey
    @ColumnInfo(name="contextID")
    @NonNull
    private String id;
    @ColumnInfo(name="refreshTime")
    private long refreshRate;
    @ColumnInfo(name="isSupported")
    private boolean isSupported;
    @ColumnInfo(name="className")
    private String className;
    @ColumnInfo(name="isEnabled")
    private boolean isEnabled;
    @Ignore
    private String name;
    @Ignore
    private boolean isReserved;
    @Ignore
    private HashMap<String, String> listOfAttributes;

    public Plugin() {
    }

    public Plugin(@NonNull String id, @NonNull String name, long refreshRate, boolean isEnabled, boolean isReserved, boolean isSupported) {
        this(id, name, refreshRate, isEnabled, isReserved, isSupported, new HashMap<String, String>());
    }

    public Plugin(@NonNull String id, @NonNull String name, long refreshRate, boolean isEnabled, boolean isReserved, boolean isSupported, HashMap<String, String> listOfAttributes) {
        this.id = id;
        this.isEnabled = isEnabled;
        this.isReserved = isReserved;
        this.name = name;
        this.refreshRate = refreshRate;
        this.isSupported = isSupported;
        this.listOfAttributes = listOfAttributes;
    }

    public static ContextPluginResult get(final @NonNull Context mContext, final @NonNull QueryParameters params, @NonNull PagedResultCallback<Plugin> callback) {
        Handler handler = new Handler(Looper.getMainLooper());
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final ContextPluginResult result = new ContextPluginResult(mContext, params, callback, executorService, handler);
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    DeserializeContextPlugins deserializer = new DeserializeContextPlugins();
                    Result getPlugins = FlyAway.get((Context)mContext, (String)Plugin.API, (QueryParameters)params, (IDeserializer)deserializer, (String)"Plugin.get");
                    result.setResult(getPlugins);
                }
                catch (FlybitsException e) {
                    result.setResult(new Result(e, "Plugin.get() failed"));
                }
            }
        });
        return result;
    }

    @Nullable
    public HashMap<String, String> getAttributes() {
        return this.listOfAttributes;
    }

    @Nullable
    public String getClassName() {
        return this.className;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public long getRefreshRate() {
        return this.refreshRate;
    }

    public boolean isSupported() {
        return this.isEnabled && this.isSupported;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public boolean isReserved() {
        return this.isReserved;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setRefreshRate(long refreshRate) {
        this.refreshRate = refreshRate;
    }

    public void setSupported(boolean supported) {
        this.isSupported = supported;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Plugin plugin = (Plugin)o;
        return this.id != null ? this.id.equals(plugin.id) : plugin.id == null;
    }
}

