package com.flybits.context.plugins.network

import android.Manifest
import android.content.Context
import android.net.ConnectivityManager
import android.os.Bundle
import androidx.work.WorkerParameters
import com.flybits.commons.library.logging.Logger
import com.flybits.context.models.ContextData
import com.flybits.context.services.FlybitsContextPluginsWorker

const val TAG = "PluginNetwork"

/**
 * The [NetworkContextPluginWorker] is a worker responsible for retrieving the details of network connected.
 * This will be triggered by `WorkManager` on start of network plugin to fetch the network information after specified interval.
 * The minimum interval for the worker to execute is 900 seconds.
 * Permissions required are : ACCESS_WIFI_STATE and ACCESS_NETWORK_STATE in your app manifest.
 */
class NetworkContextPluginWorker(context: Context, workerParameters: WorkerParameters) :
    FlybitsContextPluginsWorker(context, workerParameters) {

    override fun getData(): ContextData {
        Logger.appendTag(TAG).d("Fetching Network Data...")
        val cm = applicationContext.getSystemService(Context.CONNECTIVITY_SERVICE)
        return if (cm is ConnectivityManager) {
            val activeNetwork = cm.activeNetworkInfo
            NetworkData(applicationContext, activeNetwork)
        } else throw NullPointerException("getSystemService() returns null")
    }

    override fun getRequiredPermissions(): Array<String> {
        return arrayOf(
            Manifest.permission.ACCESS_WIFI_STATE,
            Manifest.permission.ACCESS_NETWORK_STATE
        )
    }

    override fun initialize(bundle: Bundle?) {}

    override fun isSupported(): Boolean {
        return true
    }
}