package com.flybits.context.services

import android.os.Bundle
import com.flybits.context.ReservedContextPlugin
import com.flybits.context.models.ContextData
import com.flybits.context.plugins.ContextPlugin

/**
 * Provides functions for retrieving [ContextData]
 */
interface ContextDataRetriever {
    /**
     * Get the [ContextData] that is associated to this [ContextDataRetriever], each
     * ContextPlugin should have a corresponding [ContextData] object as this is
     * delivered to the Flybits Context Server.
     *
     * @return The [ContextData] object associated to this [ContextPlugin].
     */
    fun getData(): ContextData


    /**
     * Gets the list of required permissions that should be declared within the application's
     * `AndroidManifest.xml` file in order of this [ContextDataRetriever] to function correctly.
     *
     * @return The list of permissions that should be declared within the application's
     * `AndroidManifest.xml` file.
     */
    fun getRequiredPermissions(): Array<String>

    /**
     * Initializes the `FlybitsContextPluginsWorker` so that it can initialize all the
     * necessary variables.
     *
     * @param bundle The bundle which may contain additional data needed for the
     * `FlybitsContextPluginsWorker` to correctly initialize itself.
     */
    fun initialize(bundle: Bundle?)

    /**
     * Indicates whether or not the device's features support this
     * [ContextPlugin]. For example, if your device does not have
     * BlueTooth support than the [ReservedContextPlugin.BEACON] will not
     * be able to function correctly in this case. Each [ContextPlugin] should implement its
     * own checks to make sure the device supports all the necessary features.
     *
     * @return true if the device supports the various features needed for this
     * [ContextPlugin] to function correctly, false otherwise.
     */
    fun isSupported(): Boolean

}