/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.concierge;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import android.support.design.widget.Snackbar;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.URLUtil;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.afollestad.materialdialogs.MaterialDialog;
import com.flybits.commons.library.api.FlybitsManager;
import com.flybits.commons.library.api.FlybitsScope;
import com.flybits.commons.library.api.results.callbacks.ObjectResultCallback;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.logging.Logger;
import com.flybits.commons.library.models.User;
import com.flybits.concierge.AuthenticationStatusListener;
import com.flybits.concierge.DisplayConfiguration;
import com.flybits.concierge.FlybitsConcierge;
import com.flybits.concierge.FlybitsNavigator;
import com.flybits.concierge.InternalPreferences;
import com.flybits.concierge.OptedStateChangeListener;
import com.flybits.concierge.R;
import com.flybits.concierge.activities.DocumentActivity;
import com.flybits.concierge.activities.NotificationsActivity;
import com.flybits.concierge.activities.SettingsActivity;
import com.flybits.concierge.analytics.VisibilityObservable;
import com.flybits.concierge.analytics.VisibilityStateChangeListener;
import com.flybits.concierge.enums.DisplayType;
import com.flybits.concierge.fragments.FeedHolderFragment;
import com.flybits.concierge.fragments.OptInErrorStateFragment;
import com.flybits.concierge.fragments.OptInFragment;
import com.flybits.concierge.fragments.OptOutConfirmationFragment;
import com.flybits.concierge.fragments.TransitionLoaderFragment;
import com.flybits.internal.db.CommonsDatabase;
import com.flybits.internal.db.UserDAO;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executors;
import org.jetbrains.annotations.NotNull;

public class ConciergeFragment
extends Fragment
implements AuthenticationStatusListener,
OptedStateChangeListener,
FlybitsNavigator,
VisibilityObservable {
    public static final String INSTANCE_CURRENT_FRAGMENT = "instance_current_fragment";
    public static final String ARG_MENU_TYPE = "flybits_con_menu_type";
    public static final String ARG_SHOW_OPT_OUT = "flybits_con_show_opt_out";
    public static final String ARG_SHOW_SETTINGS = "flybits_con_show_settings";
    public static final String ARG_OPT_OUT_TITLE = "flybits_con_opt_out_title";
    public static final String ARG_OPT_OUT_MESSAGE = "flybits_con_opt_out_message";
    public static final String CONCIERGE_FRAGMENT_TAG = "ConciergeFragmentTag";
    public static FlybitsScope flybitsScope;
    public String CONCIERGE_LOG_TAG = "ConFragment";
    Handler handler;
    private LinearLayout lytLoader;
    private TextView txtLoaderText;
    private LinearLayout errorViewContainer;
    private View mainViewContainer;
    private Context currentContext;
    private Fragment currentFragment;
    private FragmentManager childFragmentManager;
    private boolean initializing = false;
    private boolean actionBarItemsVisible = true;
    private boolean menuVisible = false;
    private boolean isVisible = false;
    private boolean firstResume = true;
    private MenuType menuType = null;
    private boolean showOptOutOption = true;
    private boolean showSettings = true;
    private String optOutTitle = null;
    private String optOutMessage = null;
    private Set<VisibilityStateChangeListener> visibilityStateChangeListeners;
    private FlybitsConcierge flybitsConcierge;

    @Deprecated
    public static ConciergeFragment newInstance(MenuType menuType) {
        ConciergeFragment fragment = new ConciergeFragment();
        Bundle bundle = new Bundle();
        bundle.putInt(ARG_MENU_TYPE, menuType.value);
        fragment.setArguments(bundle);
        return fragment;
    }

    public static ConciergeFragment newInstance(DisplayConfiguration configuration) {
        ConciergeFragment fragment = new ConciergeFragment();
        Bundle bundle = new Bundle();
        bundle.putInt(ARG_MENU_TYPE, configuration.getMenuType().getValue());
        bundle.putBoolean(ARG_SHOW_OPT_OUT, configuration.getShowOptOutOption());
        bundle.putString(ARG_OPT_OUT_TITLE, configuration.getOptOutTitle());
        bundle.putString(ARG_OPT_OUT_MESSAGE, configuration.getOptOutMessage());
        bundle.putBoolean(ARG_SHOW_SETTINGS, configuration.getShowSettings());
        fragment.setArguments(bundle);
        return fragment;
    }

    @Override
    public void openSnackbar(@NotNull String content, int length) {
        View view = this.getView();
        if (view != null) {
            Snackbar.make((View)view, (CharSequence)content, (int)-1).show();
        }
    }

    @Override
    public void dismiss() {
        if (this.childFragmentManager != null) {
            this.childFragmentManager.popBackStack();
        }
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.childFragmentManager = this.getChildFragmentManager();
        if (this.getActivity() != null) {
            this.getActivity().setRequestedOrientation(1);
        }
        if (savedInstanceState != null && this.childFragmentManager != null) {
            this.currentFragment = this.childFragmentManager.getFragment(savedInstanceState, INSTANCE_CURRENT_FRAGMENT);
        }
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        if (this.currentFragment != null && this.childFragmentManager != null) {
            this.childFragmentManager.putFragment(outState, INSTANCE_CURRENT_FRAGMENT, this.currentFragment);
        }
        outState.putBoolean("flybits_con_error_present", this.errorViewContainer.getVisibility() == 0);
    }

    public void onPause() {
        super.onPause();
        Logger.appendTag((String)this.CONCIERGE_LOG_TAG).d("onPause()");
        if (this.flybitsConcierge != null) {
            this.flybitsConcierge.unregisterAuthenticationStateListener(this);
            this.flybitsConcierge.unregisterOptedStateChangeListener(this);
        }
        if (this.menuVisible) {
            this.onVisibilityStateChange(false);
        }
    }

    public void onResume() {
        super.onResume();
        Logger.appendTag((String)this.CONCIERGE_LOG_TAG).d("onResume()");
        if (this.flybitsConcierge != null) {
            this.flybitsConcierge.registerAuthenticationStateListener(this);
            this.flybitsConcierge.registerOptedStateChangeListener(this);
        }
        if (this.menuVisible && !this.firstResume) {
            this.onVisibilityStateChange(true);
        }
        this.firstResume = false;
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.flybits_con_fragment_concierge, container, false);
    }

    private void userUpdate(Context context, boolean optedState) {
        UserDAO userDAO = CommonsDatabase.getDatabase((Context)context).userDao();
        User user = userDAO.getActiveUser();
        if (user != null) {
            user.setOptedIn(optedState);
            userDAO.update(user);
        }
    }

    public void onViewCreated(@NotNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.registerConciergeScope();
        this.visibilityStateChangeListeners = Collections.synchronizedSet(new HashSet());
        this.setHasOptionsMenu(true);
        Bundle args = this.getArguments();
        if (args != null) {
            this.menuType = MenuType.fromInt(args.getInt(ARG_MENU_TYPE, MenuType.MENU_TYPE_APP_BAR.value));
            this.showOptOutOption = args.getBoolean(ARG_SHOW_OPT_OUT, true);
            this.optOutTitle = args.getString(ARG_OPT_OUT_TITLE, null);
            this.optOutMessage = args.getString(ARG_OPT_OUT_MESSAGE, null);
            this.showSettings = args.getBoolean(ARG_SHOW_SETTINGS, true);
        }
        this.lytLoader = (LinearLayout)view.findViewById(R.id.concierge_fragment_lytLoader);
        this.txtLoaderText = (TextView)view.findViewById(R.id.concierge_fragment_txtLoadingText);
        this.errorViewContainer = (LinearLayout)view.findViewById(R.id.concierge_fragment_error_holder);
        this.mainViewContainer = view.findViewById(this.contentLayout());
        this.flybitsConcierge = FlybitsConcierge.with(this.currentContext);
        if (!InternalPreferences.is2PhaseOptIn(this.currentContext)) {
            this.initializeState();
        } else if (InternalPreferences.isOnBoardingDone(this.currentContext)) {
            this.initializeState(DisplayType.SHOW_CONTENT);
        } else {
            this.initializeState(DisplayType.SHOW_OPT_IN);
        }
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        this.currentContext = context;
    }

    public void onDetach() {
        super.onDetach();
    }

    @UiThread
    public void initializeState(DisplayType displayType) {
        this.handler = new Handler(Looper.getMainLooper());
        this.handler.post(() -> {
            if (this.initializing) {
                return;
            }
            this.initializing = true;
            boolean is2PhaseOptedIn = InternalPreferences.is2PhaseOptIn(this.currentContext);
            this.errorViewContainer.setVisibility(8);
            this.mainViewContainer.setVisibility(4);
            if (is2PhaseOptedIn) {
                switch (displayType) {
                    case SHOW_OPT_IN: 
                    case SHOW_LOADING: 
                    case SHOW_ERROR: {
                        this.mainViewContainer.setVisibility(0);
                        this.hideLoader();
                        this.currentFragment = displayType.equals((Object)DisplayType.SHOW_OPT_IN) ? OptInFragment.Companion.newInstance() : (displayType.equals((Object)DisplayType.SHOW_LOADING) ? TransitionLoaderFragment.Companion.newInstance() : OptInErrorStateFragment.Companion.newInstance(this.flybitsConcierge.getOptInError()));
                        if (!this.isAdded()) break;
                        if (this.childFragmentManager != null) {
                            this.childFragmentManager.beginTransaction().replace(this.contentLayout(), this.currentFragment).addToBackStack(null).commit();
                        }
                        this.setActionBarItemsVisibility(false);
                        this.initializing = false;
                        break;
                    }
                    case SHOW_OPT_OUT_CONFIRMATION: {
                        this.mainViewContainer.setVisibility(0);
                        this.hideLoader();
                        this.currentFragment = OptOutConfirmationFragment.Companion.newInstance();
                        if (this.isAdded() && this.childFragmentManager != null) {
                            this.childFragmentManager.beginTransaction().replace(this.contentLayout(), this.currentFragment).addToBackStack(null).commit();
                        }
                        InternalPreferences.setOptOutConfirmationAdded(this.currentContext, false);
                        this.setActionBarItemsVisibility(false);
                        this.initializing = false;
                        break;
                    }
                    case SHOW_CONTENT: {
                        this.mainViewContainer.setVisibility(0);
                        if (this.mainViewContainer instanceof FrameLayout) {
                            ((FrameLayout)this.mainViewContainer).removeAllViewsInLayout();
                        }
                        this.hideLoader();
                        Bundle arguments = this.getArguments();
                        boolean showMoreTab = false;
                        if (arguments != null) {
                            MenuType menuType = MenuType.fromInt(arguments.getInt(ARG_MENU_TYPE, MenuType.MENU_TYPE_APP_BAR.value));
                            showMoreTab = menuType != MenuType.MENU_TYPE_APP_BAR;
                        }
                        FlybitsManager.addScope((FlybitsScope)flybitsScope);
                        this.currentFragment = FeedHolderFragment.Companion.newInstance(showMoreTab, this.showOptOutOption, this.optOutTitle, this.optOutMessage, this.showSettings);
                        if (!this.isAdded()) break;
                        if (this.childFragmentManager != null) {
                            this.childFragmentManager.beginTransaction().replace(this.contentLayout(), this.currentFragment, this.currentFragment.getClass().getSimpleName()).addToBackStack(null).commit();
                        }
                        this.setActionBarItemsVisibility(true);
                        this.initializing = false;
                        break;
                    }
                }
            }
        });
    }

    @UiThread
    public void initializeState() {
        this.handler = new Handler(Looper.getMainLooper());
        this.handler.post(() -> {
            if (this.initializing) {
                return;
            }
            this.initializing = true;
            this.errorViewContainer.setVisibility(8);
            this.mainViewContainer.setVisibility(4);
            if (this.flybitsConcierge.isAuthenticated()) {
                this.mainViewContainer.setVisibility(0);
                this.flybitsConcierge.isOptedInLocal(new ObjectResultCallback<Boolean>(){

                    public void onSuccess(Boolean optedIn) {
                        ConciergeFragment.this.flybitsConcierge.unregisterAuthenticationStateListener(ConciergeFragment.this);
                        if (!optedIn.booleanValue()) {
                            ConciergeFragment.this.hideLoader();
                            if (InternalPreferences.isOptOutConfirmationAdded(ConciergeFragment.this.currentContext)) {
                                if (ConciergeFragment.this.isAdded()) {
                                    ConciergeFragment.this.currentFragment = OptInFragment.Companion.newInstance();
                                    if (ConciergeFragment.this.childFragmentManager != null) {
                                        ConciergeFragment.this.childFragmentManager.beginTransaction().replace(ConciergeFragment.this.contentLayout(), ConciergeFragment.this.currentFragment).addToBackStack(null).commit();
                                    }
                                    ConciergeFragment.this.setActionBarItemsVisibility(false);
                                }
                            } else if (!InternalPreferences.isOptOutConfirmation(ConciergeFragment.this.currentContext)) {
                                if (ConciergeFragment.this.isAdded()) {
                                    ConciergeFragment.this.currentFragment = OptInFragment.Companion.newInstance();
                                    if (ConciergeFragment.this.childFragmentManager != null) {
                                        ConciergeFragment.this.childFragmentManager.beginTransaction().replace(ConciergeFragment.this.contentLayout(), ConciergeFragment.this.currentFragment).addToBackStack(null).commit();
                                    }
                                    ConciergeFragment.this.setActionBarItemsVisibility(false);
                                }
                            } else if (ConciergeFragment.this.isAdded()) {
                                ConciergeFragment.this.currentFragment = OptOutConfirmationFragment.Companion.newInstance();
                                if (ConciergeFragment.this.childFragmentManager != null) {
                                    ConciergeFragment.this.childFragmentManager.beginTransaction().replace(ConciergeFragment.this.contentLayout(), ConciergeFragment.this.currentFragment).addToBackStack(null).commit();
                                }
                                InternalPreferences.setOptOutConfirmationAdded(ConciergeFragment.this.currentContext, false);
                                ConciergeFragment.this.setActionBarItemsVisibility(false);
                            }
                        } else if (!(ConciergeFragment.this.currentFragment instanceof FeedHolderFragment)) {
                            ConciergeFragment.this.mainViewContainer.setVisibility(0);
                            if (ConciergeFragment.this.mainViewContainer instanceof FrameLayout) {
                                ((FrameLayout)ConciergeFragment.this.mainViewContainer).removeAllViewsInLayout();
                            }
                            ConciergeFragment.this.hideLoader();
                            Bundle arguments = ConciergeFragment.this.getArguments();
                            boolean showMoreTab = false;
                            if (arguments != null) {
                                MenuType menuType = MenuType.fromInt(arguments.getInt(ConciergeFragment.ARG_MENU_TYPE, MenuType.MENU_TYPE_APP_BAR.value));
                                showMoreTab = menuType != MenuType.MENU_TYPE_APP_BAR;
                            }
                            FlybitsManager.addScope((FlybitsScope)flybitsScope);
                            if (ConciergeFragment.this.isAdded()) {
                                ConciergeFragment.this.currentFragment = FeedHolderFragment.Companion.newInstance(showMoreTab, ConciergeFragment.this.showOptOutOption, ConciergeFragment.this.optOutTitle, ConciergeFragment.this.optOutMessage, ConciergeFragment.this.showSettings);
                                if (ConciergeFragment.this.childFragmentManager != null) {
                                    ConciergeFragment.this.childFragmentManager.beginTransaction().replace(ConciergeFragment.this.contentLayout(), ConciergeFragment.this.currentFragment, ConciergeFragment.this.currentFragment.getClass().getSimpleName()).commit();
                                }
                                ConciergeFragment.this.setActionBarItemsVisibility(true);
                            }
                        }
                        ConciergeFragment.this.initializing = false;
                    }

                    public void onException(@NotNull FlybitsException e) {
                        ConciergeFragment.this.initializing = false;
                    }
                });
            } else if (!this.flybitsConcierge.isAuthenticating()) {
                boolean retrySuccess = this.flybitsConcierge.retryAuthentication();
                if (retrySuccess) {
                    this.showLoader("");
                }
                this.errorViewContainer.setVisibility(0);
                this.setActionBarItemsVisibility(false);
                this.initializing = false;
            } else {
                this.setActionBarItemsVisibility(false);
                this.initializing = false;
                this.showLoader("");
            }
        });
    }

    private void registerConciergeScope() {
        String conciergeScope = "ConciergeScope" + this.getId();
        flybitsScope = new FlybitsScope(conciergeScope){

            public void onStart() {
            }

            public void onStop() {
            }

            public void onConnected(Context context, User user) {
            }

            public void onDisconnected(Context context, String jwtToken) {
            }

            public void onAccountDestroyed(Context context, String jwtToken) {
            }

            public void onOptedStateChange(Context context, boolean optedState) {
                Executors.newSingleThreadExecutor().execute(() -> ConciergeFragment.this.userUpdate(context, optedState));
                if (!optedState) {
                    Logger.appendTag((String)ConciergeFragment.this.CONCIERGE_LOG_TAG).d("User Opted Out of Flybits.");
                    if (!InternalPreferences.isSelfOptedOut(context)) {
                        if (ConciergeFragment.this.isAdded()) {
                            ConciergeFragment.this.currentFragment = OptOutConfirmationFragment.newInstance();
                            if (ConciergeFragment.this.childFragmentManager != null) {
                                ConciergeFragment.this.childFragmentManager.beginTransaction().replace(ConciergeFragment.this.contentLayout(), ConciergeFragment.this.currentFragment).addToBackStack(null).commit();
                            }
                            ConciergeFragment.this.setActionBarItemsVisibility(false);
                        }
                    } else {
                        InternalPreferences.setSelfUserOptedOut(context, false);
                        if (ConciergeFragment.this.isAdded()) {
                            ConciergeFragment.this.currentFragment = OptOutConfirmationFragment.newInstance();
                            if (ConciergeFragment.this.childFragmentManager != null) {
                                ConciergeFragment.this.childFragmentManager.beginTransaction().replace(ConciergeFragment.this.contentLayout(), ConciergeFragment.this.currentFragment).addToBackStack(null).commitAllowingStateLoss();
                            }
                            ConciergeFragment.this.setActionBarItemsVisibility(false);
                        }
                        InternalPreferences.setOptOutConfirmation(context, true);
                    }
                    FlybitsManager.removeScope((FlybitsScope)flybitsScope);
                } else {
                    Logger.appendTag((String)ConciergeFragment.this.CONCIERGE_LOG_TAG).d("User has Opted In Flybits.");
                    ConciergeFragment.this.initializing = false;
                    if (!InternalPreferences.is2PhaseOptIn(context)) {
                        ConciergeFragment.this.initializeState();
                    } else {
                        ConciergeFragment.this.initializeState(DisplayType.SHOW_LOADING);
                    }
                }
            }
        };
    }

    public void onCreateOptionsMenu(Menu menu2, MenuInflater inflater) {
        Logger.appendTag((String)this.CONCIERGE_LOG_TAG).d("onCreateOptionsMenu()");
        this.onVisibilityStateChange(true);
        if (this.menuType == MenuType.MENU_TYPE_APP_BAR && this.showSettings) {
            inflater.inflate(R.menu.menu, menu2);
            menu2.findItem(R.id.notifications).setVisible(this.actionBarItemsVisible);
            menu2.findItem(R.id.settings).setVisible(this.actionBarItemsVisible);
            if (this.currentFragment instanceof OptInFragment) {
                menu2.findItem(R.id.declineOptin).setVisible(true);
            } else {
                menu2.findItem(R.id.declineOptin).setVisible(false);
            }
        } else {
            super.onCreateOptionsMenu(menu2, inflater);
        }
    }

    public void onDestroyOptionsMenu() {
        super.onDestroyOptionsMenu();
        this.onVisibilityStateChange(false);
        this.menuVisible = false;
    }

    public void registerMenu() {
        if (!this.firstResume) {
            this.onVisibilityStateChange(true);
        }
        this.menuVisible = true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int id2 = item.getItemId();
        if (id2 == R.id.settings) {
            Intent startSettingsIntent = new Intent(this.getContext(), SettingsActivity.class);
            startSettingsIntent.putExtra("flybits_con_show_opt_out_cell", this.showOptOutOption);
            startSettingsIntent.putExtra("flybits_con_opt_out_cell_title", this.optOutTitle);
            startSettingsIntent.putExtra("flybits_con_opt_out_cell_message", this.optOutMessage);
            this.startActivityForResult(startSettingsIntent, 1);
            return true;
        }
        if (id2 == R.id.notifications) {
            Intent startNotificationsIntent = new Intent(this.getContext(), NotificationsActivity.class);
            this.startActivity(startNotificationsIntent);
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    private void setActionBarItemsVisibility(boolean visible) {
        this.actionBarItemsVisible = visible;
        FragmentActivity activity = this.getActivity();
        if (activity != null) {
            activity.invalidateOptionsMenu();
        }
    }

    @Override
    public void openFragment(@NotNull Fragment fragment, boolean addToBackStack) {
        FragmentActivity fragmentActivity = this.getActivity();
        if (fragmentActivity != null && this.childFragmentManager != null) {
            FragmentTransaction transaction = this.childFragmentManager.beginTransaction();
            if (addToBackStack) {
                transaction.addToBackStack(null);
            }
            transaction.replace(this.contentLayout(), fragment).commit();
        }
    }

    public void openActivity(Class activity, Bundle extras) {
        Intent intent = new Intent(this.currentContext, activity);
        intent.putExtras(extras);
        this.startActivity(intent);
    }

    private void showLoader(String title) {
        if (this.currentFragment != null && this.childFragmentManager != null) {
            this.childFragmentManager.beginTransaction().remove(this.currentFragment).commit();
        }
        this.txtLoaderText.setText((CharSequence)title);
        this.lytLoader.setVisibility(0);
    }

    private void hideLoader() {
        this.lytLoader.setVisibility(8);
    }

    private int contentLayout() {
        return R.id.concierge_fragment_lytContent;
    }

    public void setCallback(IConciergeFragmentCallbacks callback) {
    }

    @Override
    public void onAuthenticated() {
        if (!InternalPreferences.is2PhaseOptIn(this.getContext())) {
            this.initializeState();
        }
    }

    @Override
    public void onAuthenticationStarted() {
    }

    @Override
    public void onAuthenticationError(FlybitsException e) {
        this.mainViewContainer.setVisibility(8);
        this.errorViewContainer.setVisibility(0);
        this.hideLoader();
    }

    @Override
    public void onOptedStateChange(boolean optedIn) {
        if (this.getActivity() != null) {
            this.initializeState();
        }
    }

    @Override
    public void onSwitchFragment(DisplayType displayType) {
        if (this.getActivity() != null) {
            this.initializeState(displayType);
        }
    }

    @Override
    public boolean openUrl(@NotNull String url) {
        FragmentActivity activity = this.getActivity();
        if (activity == null) {
            return false;
        }
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setData(Uri.parse((String)url));
        if (URLUtil.isValidUrl((String)url)) {
            this.startActivity(intent);
            return true;
        }
        return false;
    }

    @Override
    public boolean openUrlInApp(@NotNull String url) {
        Context context = this.getContext();
        if (context == null) {
            return false;
        }
        if (URLUtil.isValidUrl((String)url)) {
            Intent activityIntent = new Intent(context, DocumentActivity.class);
            activityIntent.putExtra("flybits_con_extra_document_type", "flybits_con_document_type_url");
            activityIntent.putExtra("flybits_con_document_client_url", url);
            this.startActivity(activityIntent);
            return true;
        }
        return false;
    }

    @Override
    public void openDialog(@NotNull String content, @NotNull String title) {
        new MaterialDialog.Builder((Context)this.getActivity()).title((CharSequence)title).content((CharSequence)content).positiveText(17039370).dismissListener(dialogInterface -> this.getActivity().finish()).show();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerVisibilityStateChangeListener(VisibilityStateChangeListener v) {
        Set<VisibilityStateChangeListener> set = this.visibilityStateChangeListeners;
        synchronized (set) {
            this.visibilityStateChangeListeners.add(v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterVisibilityStateChangeListener(VisibilityStateChangeListener v) {
        Set<VisibilityStateChangeListener> set = this.visibilityStateChangeListeners;
        synchronized (set) {
            this.visibilityStateChangeListeners.remove(v);
        }
    }

    public boolean isVisibleToUser() {
        return this.isVisible;
    }

    private void onVisibilityStateChange(boolean visibility) {
        if (this.isVisible != visibility) {
            this.isVisible = visibility;
            HashSet<VisibilityStateChangeListener> listenersSet = new HashSet<VisibilityStateChangeListener>(this.visibilityStateChangeListeners);
            for (VisibilityStateChangeListener listener : listenersSet) {
                listener.onVisibilityStateChange(visibility);
            }
        }
    }

    public static interface IConciergeFragmentCallbacks {
        public void onTNCDecline();
    }

    public static enum MenuType {
        MENU_TYPE_APP_BAR(0),
        MENU_TYPE_TAB(1);

        private int value;

        private MenuType(int value) {
            this.value = value;
        }

        public static MenuType fromInt(int type) {
            if (type == 0) {
                return MENU_TYPE_APP_BAR;
            }
            if (type == 1) {
                return MENU_TYPE_TAB;
            }
            throw new IllegalArgumentException("Type is invalid use TYPE_TAB or TYPE_APP_BAR");
        }

        public int getValue() {
            return this.value;
        }
    }
}

