package com.flybits.concierge.activities

import android.content.Intent
import android.net.Uri
import android.os.Bundle
import android.support.design.widget.Snackbar
import android.support.v4.app.Fragment
import android.support.v7.app.AppCompatActivity
import android.view.MenuItem
import android.webkit.URLUtil
import com.afollestad.materialdialogs.MaterialDialog
import com.flybits.android.push.models.newPush.Push
import com.flybits.commons.library.logging.Logger
import com.flybits.concierge.ConciergeConstants
import com.flybits.concierge.FlybitsNavigator
import com.flybits.concierge.R
import com.flybits.concierge.fragments.NotificationsFragment

class NotificationsActivity : AppCompatActivity(), FlybitsNavigator {

    override fun openFragment(fragment: Fragment, addToBackStack: Boolean) {
        val transaction = supportFragmentManager.beginTransaction()
        if (addToBackStack) {
            transaction.addToBackStack(null)
        }
        transaction.replace(R.id.flybits_con_activity_notifications_fragment_holder, fragment)
            .commit()
    }

    override fun openActivity(activity: Class<*>, extras: Bundle) {
        val intent = Intent(this, activity)
        intent.putExtras(extras)
        startActivity(intent)
    }

    override fun openUrl(url: String): Boolean {
        val intent = Intent(Intent.ACTION_VIEW, Uri.parse(url))
        //verify that you're able to open url, if URL is malformed then exception is thrown
        return if (URLUtil.isValidUrl(url)) {
            startActivity(intent)
            true
        } else {
            Logger.e("NotificationsActivity: Unable to show url $url, make sure it has http:// prefixed.")
            false
        }
    }

    override fun openUrlInApp(url: String): Boolean {
        val context = applicationContext ?: return false
        return if (URLUtil.isValidUrl(url)) {
            val activityIntent = Intent(context, DocumentActivity::class.java)
            activityIntent.putExtra(
                DocumentActivity.EXTRA_DOCUMENT_TYPE,
                DocumentActivity.DOCUMENT_TYPE_URL
            )
            activityIntent.putExtra(DocumentActivity.EXTRA_DOCUMENT_CLIENT_URL, url)
            startActivity(activityIntent)
            true
        } else {
            false
        }
    }

    override fun openDialog(content: String, title: String) {
        MaterialDialog.Builder(this)
            .title(title)
            .content(content)
            .positiveText(android.R.string.ok)
            .show()
    }

    override fun onOptionsItemSelected(item: MenuItem): Boolean {
        return if (item.itemId == android.R.id.home) {
            onBackPressed()
            true
        } else {
            super.onOptionsItemSelected(item)
        }
    }

    override fun openSnackbar(content: String, length: Int) {
        Snackbar.make(findViewById(android.R.id.content), content, Snackbar.LENGTH_SHORT).show()
    }

    override fun dismiss() {
        finish()
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.flybits_con_activity_notifications)

        val actionBar = supportActionBar
        actionBar?.setDisplayHomeAsUpEnabled(true)
        actionBar?.title = getString(R.string.flybits_con_notifications)

        val notificationsFragment = if (intent.hasExtra(ConciergeConstants.PUSH_EXTRA)) {
            val push = intent.getParcelableExtra<Push>(ConciergeConstants.PUSH_EXTRA)
            intent.removeExtra(ConciergeConstants.PUSH_EXTRA)
            NotificationsFragment.newInstance(push)
        } else {
            NotificationsFragment.newInstance()
        }
        openFragment(notificationsFragment, false)
    }
}