package com.flybits.concierge

import android.view.ViewGroup
import com.flybits.concierge.models.BaseTemplate
import com.flybits.concierge.viewholders.FlybitsViewHolder

interface FlybitsViewProvider<T: BaseTemplate>{

    /**
     * This method should return the class which the content will deserialize into.
     * Take a look at {@link Article} for an example.
     */
    fun getClassType(): Class<T>

    /**
     * Provides the content type that this class is associated with. There should not be
     * more than one {@link FlybitsViewProvider} with the same content type.
     */
    fun getContentType(): String

    /**
     * This method will call the RecyclerViews onCreateViewHolder method.
     *
     */
    fun onCreateViewHolder(parent: ViewGroup): FlybitsViewHolder<T> //shows up in recycler view

    /**
     * Called whenever a push notification is sent with content which matches the content type
     * returned by getContentType()
     */
    fun onPushOpened(model: T, flybitsNavigator: FlybitsNavigator) //Returns whether or not the content fragment should be opened as a result of push for model being clicked

    companion object {
        const val MODEL_EXTRA = "model_extra"
    }
}