package com.flybits.concierge.repository.push

import android.content.Context
import com.flybits.android.push.api.PushAPIManager
import com.flybits.android.push.models.newPush.Push
import com.flybits.android.push.models.results.PushResult
import com.flybits.android.push.utils.PushQueryParameters
import com.flybits.commons.library.api.results.callbacks.PagedResultCallback
import kotlinx.coroutines.Job

/**
 * Wrapper for retrieving push notifications. We use this so that context isn't passed
 * around to classes that shouldn't have access to it.
 *
 * @param context The context of the application
 */
class PushGetter(private val context: Context) {

    /**
     * Retrieve push notification
     *
     * @param params Parameters specifying the query
     * @param pagedResultCallback Callback where the results will be provided
     *
     * @return PagedResult
     */
    fun getPush(params: PushQueryParameters, pagedResultCallback: PagedResultCallback<Push>? = null): Job {

        return PushAPIManager.get(context,params, pagedResultCallback)
    }
}