package com.flybits.concierge.activities

import android.os.Bundle
import com.flybits.concierge.ConciergeFragment
import com.flybits.concierge.DisplayConfiguration
import com.flybits.concierge.InternalPreferences
import com.flybits.concierge.R
import com.flybits.concierge.enums.DisplayType

/**
 * Wrapper activity to hold the ConciergeFragment if the developer does not want to embed
 * the fragment in their views. This version has a Dialog/Popup theme to it.
 */

class ConciergePopupActivity : ConciergeAbstractActivity() {
    lateinit var fragment: ConciergeFragment
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.flybits_con_activity_concierge)

        fragment = ConciergeFragment.newInstance(
            intent.getParcelableExtra<DisplayConfiguration>(ARG_DISPLAY_CONFIGURATION)
        )
        fragment.setCallback { finish() }
        openFragment(fragment)
    }

    override fun onBackPressed() {
        if (!InternalPreferences.isOptOutConfirmationAdded(this)) {
            this.finish()
        } else {
            InternalPreferences.setOptOutConfirmationAdded(this, false)
            if (InternalPreferences.is2PhaseOptIn(this)) {
                fragment.initializeState(DisplayType.SHOW_OPT_OUT_CONFIRMATION)
            } else {
                fragment.initializeState()
            }
        }
    }

    companion object {
        const val ARG_DISPLAY_CONFIGURATION = "flybits_con_display_configuration"
    }
}
