package com.flybits.concierge.fragments

import android.arch.lifecycle.ViewModelProviders
import android.os.Bundle
import android.support.v4.app.Fragment
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import com.flybits.concierge.InternalPreferences
import com.flybits.concierge.R
import com.flybits.concierge.viewmodels.OptInViewModel
import com.flybits.concierge.viewmodels.OptInViewModelFactory
import kotlinx.android.synthetic.main.flybits_con_fragment_opt_out_confirmation.*

class OptOutConfirmationFragment : Fragment() {

    internal val viewModel: OptInViewModel by lazy {
        ViewModelProviders.of(this, OptInViewModelFactory(context!!))
            .get(OptInViewModel::class.java)
    }

    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        return inflater.inflate(
            R.layout.flybits_con_fragment_opt_out_confirmation,
            container,
            false
        )
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        opt_out_confirmation_btn.setOnClickListener {
            // on click OPT IN, we setOptOutConfirmationAdded(true)
            InternalPreferences.setOptOutConfirmationAdded(context, true)
            if (InternalPreferences.is2PhaseOptIn(context)) {
                viewModel.optInOnOptOutConfirmation2Phase()
            } else {
                viewModel.optInOnOptOutConfirmation()
            }
        }
    }

    companion object {
        @JvmStatic
        fun newInstance(): OptOutConfirmationFragment {
            val fragment = OptOutConfirmationFragment()
            val args = Bundle()
            fragment.arguments = args
            return fragment
        }
    }
}