package com.flybits.concierge

import android.os.Parcelable
import com.flybits.concierge.enums.ShowMode
import kotlinx.android.parcel.Parcelize

/**
 * Describes how the Concierge should be displayed to the end user.
 *
 * @param menuType The [ConciergeFragment.MenuType] to be used in the navigation bar.
 * @param showMode The [ShowMode] that the Concierge will be displayed with.
 * @param showOptOutOption Whether the option to opt out should be displayed to the user throughout the Concierge.
 * @param optOutTitle The title in the opt out pop up NOTE: showOptOutOption has to be true to access this popup
 * @param optOutMessage The message in the opt out pop up NOTE: showOptOutOption has to be true to access this popup.
 * @param showSettings Whether the settings options should be displayed to the user throughout the Concierge default is true.
 */
@Parcelize
data class DisplayConfiguration @JvmOverloads constructor(
    val menuType: ConciergeFragment.MenuType,
    val showMode: ShowMode,
    val showOptOutOption: Boolean,
    val optOutTitle: String? = null,
    val optOutMessage: String? = null,
    val showSettings: Boolean = true
) : Parcelable