package com.flybits.concierge

import com.flybits.commons.library.api.idps.IDP

/**
 *  Will be triggered by the user to connect to the Flybits Server in Two Phase OptIn.
 */

interface ConciergeConnectCallBack {

    /**
     * Used to get reference to {@code FlybitsConcierge} singleton instance.
     *
     * @param idp {@code IDP} for the user being authenticated.
     * @param error The error string will be provided by the user.
     *
     */
    fun connect(idp: IDP?, error: String?)
}