package com.flybits.concierge.analytics

/**
 * Subscribe or unsubscribe [VisibilityStateChangeListener] to changes about the visibility of a thing.
 */
interface VisibilityObservable {

    /**
     * @param visibilityStateChangeListener [VisibilityStateChangeListener] to be registered.
     */
    fun registerVisibilityStateChangeListener(visibilityStateChangeListener: VisibilityStateChangeListener)

    /**
     * @param visibilityStateChangeListener [VisibilityStateChangeListener] to be unregistered.
     */
    fun unregisterVisibilityStateChangeListener(visibilityStateChangeListener: VisibilityStateChangeListener)
}