/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.concierge.viewmodels;

import android.arch.lifecycle.LiveData;
import android.arch.lifecycle.MutableLiveData;
import android.arch.lifecycle.ViewModel;
import com.flybits.commons.library.api.results.callbacks.BasicResultCallback;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.logging.Logger;
import com.flybits.concierge.FlybitsConcierge;
import com.flybits.concierge.R;
import com.flybits.concierge.ResourceProvider;
import com.flybits.concierge.enums.DisplayType;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0002\u001e\u001fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0016J\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\bJ\u0006\u0010\u001a\u001a\u00020\u0016J\u0006\u0010\u001b\u001a\u00020\u0016J\u0006\u0010\u001c\u001a\u00020\u0016J\u0006\u0010\u001d\u001a\u00020\u0016R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012\u00a8\u0006 "}, d2={"Lcom/flybits/concierge/viewmodels/OptInViewModel;", "Landroid/arch/lifecycle/ViewModel;", "flybitsConcierge", "Lcom/flybits/concierge/FlybitsConcierge;", "resourceProvider", "Lcom/flybits/concierge/ResourceProvider;", "(Lcom/flybits/concierge/FlybitsConcierge;Lcom/flybits/concierge/ResourceProvider;)V", "checkboxState", "Landroid/arch/lifecycle/LiveData;", "", "getCheckboxState", "()Landroid/arch/lifecycle/LiveData;", "footerSpan", "Lcom/flybits/concierge/viewmodels/OptInViewModel$Span;", "getFooterSpan", "optInText", "", "getOptInText", "()Ljava/lang/String;", "optInTitle", "getOptInTitle", "checkboxSelected", "", "declinedOptIn", "optIn", "Lcom/flybits/concierge/viewmodels/OptInViewModel$OptInResult;", "optInErrorAction", "optInInitiated", "optInOnOptOutConfirmation", "optInOnOptOutConfirmation2Phase", "OptInResult", "Span", "concierge_release"})
public final class OptInViewModel
extends ViewModel {
    @NotNull
    private final String optInTitle;
    @NotNull
    private final LiveData<Span> footerSpan;
    @NotNull
    private final LiveData<Boolean> checkboxState;
    @NotNull
    private final String optInText;
    private final FlybitsConcierge flybitsConcierge;

    @NotNull
    public final String getOptInTitle() {
        return this.optInTitle;
    }

    @NotNull
    public final LiveData<Span> getFooterSpan() {
        return this.footerSpan;
    }

    @NotNull
    public final LiveData<Boolean> getCheckboxState() {
        return this.checkboxState;
    }

    @NotNull
    public final String getOptInText() {
        return this.optInText;
    }

    public final void checkboxSelected() {
        LiveData<Boolean> liveData = this.checkboxState;
        if (liveData == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.arch.lifecycle.MutableLiveData<kotlin.Boolean>");
        }
        Boolean bl = (Boolean)((MutableLiveData)this.checkboxState).getValue();
        ((MutableLiveData)liveData).postValue(bl != null ? Boolean.valueOf(bl == false) : null);
    }

    @NotNull
    public final LiveData<OptInResult> optIn() {
        MutableLiveData liveData = new MutableLiveData();
        this.flybitsConcierge.optIn(new BasicResultCallback(liveData){
            final /* synthetic */ MutableLiveData $liveData;

            public void onException(@NotNull FlybitsException exception) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)exception), (String)"exception");
                this.$liveData.postValue((Object)new OptInResult(false, exception));
            }

            public void onSuccess() {
                this.$liveData.postValue((Object)new OptInResult(true, null, 2, null));
            }
            {
                this.$liveData = $captured_local_variable$0;
            }
        });
        return (LiveData)liveData;
    }

    public final void declinedOptIn() {
        if (this.flybitsConcierge.getDeclineOptInCallBack() != null) {
            Logger.appendTag((String)"OptInModel").d("Opt In declined successful.");
            this.flybitsConcierge.getDeclineOptInCallBack().onSuccess();
        } else {
            Logger.appendTag((String)"OptInModel").d("Opt In declined callback returned null.");
        }
    }

    public final void optInErrorAction() {
        this.flybitsConcierge.broadcastOptedInStateChangeFor2Phase(DisplayType.SHOW_OPT_IN);
    }

    public final void optInOnOptOutConfirmation2Phase() {
        this.flybitsConcierge.broadcastOptedInStateChangeFor2Phase(DisplayType.SHOW_OPT_IN);
    }

    public final void optInOnOptOutConfirmation() {
        this.flybitsConcierge.broadcastOptedInStateChange(false);
    }

    public final void optInInitiated() {
        this.flybitsConcierge.getOptIn2PhaseCallBack().onSuccess();
    }

    public OptInViewModel(@NotNull FlybitsConcierge flybitsConcierge, @NotNull ResourceProvider resourceProvider) {
        String string2;
        Intrinsics.checkParameterIsNotNull((Object)flybitsConcierge, (String)"flybitsConcierge");
        Intrinsics.checkParameterIsNotNull((Object)resourceProvider, (String)"resourceProvider");
        this.flybitsConcierge = flybitsConcierge;
        this.footerSpan = (LiveData)new MutableLiveData();
        this.checkboxState = (LiveData)new MutableLiveData();
        String termsAndConditionsText = resourceProvider.getString(R.string.flybits_con_terms_and_conditions);
        String privacyPolicyText = resourceProvider.getString(R.string.flybits_con_settings_privacy_policy);
        String string3 = this.flybitsConcierge.getConfiguration().getOptInTermsOfService();
        if (string3 == null) {
            string3 = this.optInText = resourceProvider.getString(R.string.flybits_con_opt_in_body_default_text);
        }
        if ((string2 = this.flybitsConcierge.getConfiguration().getOptInTitle()) == null) {
            string2 = resourceProvider.getString(R.string.flybits_con_opt_in_title_default_text);
        }
        this.optInTitle = string2;
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string4 = resourceProvider.getString(R.string.flybits_con_terms_and_conditions_body);
        Object[] objectArray = new Object[]{termsAndConditionsText, privacyPolicyText};
        boolean bl = false;
        String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"java.lang.String.format(format, *args)");
        String text = string5;
        int tncStartIndex = text.length() - termsAndConditionsText.length() - privacyPolicyText.length() - 1;
        int tncEndIndex = text.length() - privacyPolicyText.length() - 1;
        int privacyPolicyStartIndex = text.length() - privacyPolicyText.length();
        LiveData<Span> liveData = this.footerSpan;
        if (liveData == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.arch.lifecycle.MutableLiveData<com.flybits.concierge.viewmodels.OptInViewModel.Span>");
        }
        ((MutableLiveData)liveData).postValue((Object)new Span(tncStartIndex, tncEndIndex, privacyPolicyStartIndex, text.length(), text));
        LiveData<Boolean> liveData2 = this.checkboxState;
        if (liveData2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.arch.lifecycle.MutableLiveData<kotlin.Boolean>");
        }
        ((MutableLiveData)liveData2).postValue((Object)false);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u00032\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/flybits/concierge/viewmodels/OptInViewModel$OptInResult;", "", "success", "", "error", "Lcom/flybits/commons/library/exceptions/FlybitsException;", "(ZLcom/flybits/commons/library/exceptions/FlybitsException;)V", "getError", "()Lcom/flybits/commons/library/exceptions/FlybitsException;", "getSuccess", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "concierge_release"})
    public static final class OptInResult {
        private final boolean success;
        @Nullable
        private final FlybitsException error;

        public final boolean getSuccess() {
            return this.success;
        }

        @Nullable
        public final FlybitsException getError() {
            return this.error;
        }

        public OptInResult(boolean success, @Nullable FlybitsException error) {
            this.success = success;
            this.error = error;
        }

        public /* synthetic */ OptInResult(boolean bl, FlybitsException flybitsException, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                flybitsException = null;
            }
            this(bl, flybitsException);
        }

        public final boolean component1() {
            return this.success;
        }

        @Nullable
        public final FlybitsException component2() {
            return this.error;
        }

        @NotNull
        public final OptInResult copy(boolean success, @Nullable FlybitsException error) {
            return new OptInResult(success, error);
        }

        public static /* synthetic */ OptInResult copy$default(OptInResult optInResult, boolean bl, FlybitsException flybitsException, int n, Object object) {
            if ((n & 1) != 0) {
                bl = optInResult.success;
            }
            if ((n & 2) != 0) {
                flybitsException = optInResult.error;
            }
            return optInResult.copy(bl, flybitsException);
        }

        @NotNull
        public String toString() {
            return "OptInResult(success=" + this.success + ", error=" + (Object)((Object)this.error) + ")";
        }

        public int hashCode() {
            int n = this.success ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            FlybitsException flybitsException = this.error;
            return n * 31 + (flybitsException != null ? ((Object)((Object)flybitsException)).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof OptInResult)) break block3;
                    OptInResult optInResult = (OptInResult)object;
                    if (this.success != optInResult.success || !Intrinsics.areEqual((Object)((Object)this.error), (Object)((Object)optInResult.error))) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\bH\u00c6\u0003J;\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001b\u001a\u00020\bH\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006\u001c"}, d2={"Lcom/flybits/concierge/viewmodels/OptInViewModel$Span;", "", "tncStartIndex", "", "tncEndIndex", "privacyPolicyStartIndex", "privacyPolicyEndIndex", "text", "", "(IIIILjava/lang/String;)V", "getPrivacyPolicyEndIndex", "()I", "getPrivacyPolicyStartIndex", "getText", "()Ljava/lang/String;", "getTncEndIndex", "getTncStartIndex", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "toString", "concierge_release"})
    public static final class Span {
        private final int tncStartIndex;
        private final int tncEndIndex;
        private final int privacyPolicyStartIndex;
        private final int privacyPolicyEndIndex;
        @NotNull
        private final String text;

        public final int getTncStartIndex() {
            return this.tncStartIndex;
        }

        public final int getTncEndIndex() {
            return this.tncEndIndex;
        }

        public final int getPrivacyPolicyStartIndex() {
            return this.privacyPolicyStartIndex;
        }

        public final int getPrivacyPolicyEndIndex() {
            return this.privacyPolicyEndIndex;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        public Span(int tncStartIndex, int tncEndIndex, int privacyPolicyStartIndex, int privacyPolicyEndIndex, @NotNull String text) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            this.tncStartIndex = tncStartIndex;
            this.tncEndIndex = tncEndIndex;
            this.privacyPolicyStartIndex = privacyPolicyStartIndex;
            this.privacyPolicyEndIndex = privacyPolicyEndIndex;
            this.text = text;
        }

        public final int component1() {
            return this.tncStartIndex;
        }

        public final int component2() {
            return this.tncEndIndex;
        }

        public final int component3() {
            return this.privacyPolicyStartIndex;
        }

        public final int component4() {
            return this.privacyPolicyEndIndex;
        }

        @NotNull
        public final String component5() {
            return this.text;
        }

        @NotNull
        public final Span copy(int tncStartIndex, int tncEndIndex, int privacyPolicyStartIndex, int privacyPolicyEndIndex, @NotNull String text) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            return new Span(tncStartIndex, tncEndIndex, privacyPolicyStartIndex, privacyPolicyEndIndex, text);
        }

        public static /* synthetic */ Span copy$default(Span span, int n, int n2, int n3, int n4, String string2, int n5, Object object) {
            if ((n5 & 1) != 0) {
                n = span.tncStartIndex;
            }
            if ((n5 & 2) != 0) {
                n2 = span.tncEndIndex;
            }
            if ((n5 & 4) != 0) {
                n3 = span.privacyPolicyStartIndex;
            }
            if ((n5 & 8) != 0) {
                n4 = span.privacyPolicyEndIndex;
            }
            if ((n5 & 0x10) != 0) {
                string2 = span.text;
            }
            return span.copy(n, n2, n3, n4, string2);
        }

        @NotNull
        public String toString() {
            return "Span(tncStartIndex=" + this.tncStartIndex + ", tncEndIndex=" + this.tncEndIndex + ", privacyPolicyStartIndex=" + this.privacyPolicyStartIndex + ", privacyPolicyEndIndex=" + this.privacyPolicyEndIndex + ", text=" + this.text + ")";
        }

        public int hashCode() {
            String string2 = this.text;
            return (((Integer.hashCode(this.tncStartIndex) * 31 + Integer.hashCode(this.tncEndIndex)) * 31 + Integer.hashCode(this.privacyPolicyStartIndex)) * 31 + Integer.hashCode(this.privacyPolicyEndIndex)) * 31 + (string2 != null ? string2.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Span)) break block3;
                    Span span = (Span)object;
                    if (this.tncStartIndex != span.tncStartIndex || this.tncEndIndex != span.tncEndIndex || this.privacyPolicyStartIndex != span.privacyPolicyStartIndex || this.privacyPolicyEndIndex != span.privacyPolicyEndIndex || !Intrinsics.areEqual((Object)this.text, (Object)span.text)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

