/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.concierge.viewmodels;

import android.arch.lifecycle.LiveData;
import android.arch.lifecycle.MutableLiveData;
import android.arch.lifecycle.ViewModel;
import com.flybits.android.kernel.models.Content;
import com.flybits.android.push.models.newPush.ContentPush;
import com.flybits.android.push.models.newPush.WeblinkPush;
import com.flybits.commons.library.api.results.callbacks.ObjectResultCallback;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.logging.Logger;
import com.flybits.concierge.FlybitsNavigator;
import com.flybits.concierge.FlybitsViewProvider;
import com.flybits.concierge.FlybitsViewProviderGetter;
import com.flybits.concierge.models.BaseTemplate;
import com.flybits.concierge.models.NotificationContent;
import com.flybits.concierge.repository.RepositoryResponse;
import com.flybits.concierge.repository.push.NotificationContentRepository;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\n2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u001c\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000b0\n2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/flybits/concierge/viewmodels/NotificationsViewModel;", "Landroid/arch/lifecycle/ViewModel;", "notificationContentRepository", "Lcom/flybits/concierge/repository/push/NotificationContentRepository;", "flybitsViewProviderGetter", "Lcom/flybits/concierge/FlybitsViewProviderGetter;", "flybitsNavigator", "Lcom/flybits/concierge/FlybitsNavigator;", "(Lcom/flybits/concierge/repository/push/NotificationContentRepository;Lcom/flybits/concierge/FlybitsViewProviderGetter;Lcom/flybits/concierge/FlybitsNavigator;)V", "getNotificationContents", "Landroid/arch/lifecycle/LiveData;", "Lcom/flybits/concierge/repository/RepositoryResponse;", "Lcom/flybits/concierge/viewmodels/NotificationsViewModel$ViewModelNotificationContent;", "findPosition", "Lcom/flybits/android/push/models/newPush/ContentPush;", "handlePassedPush", "", "push", "", "ViewModelNotificationContent", "concierge_release"})
public final class NotificationsViewModel
extends ViewModel {
    private final NotificationContentRepository notificationContentRepository;
    private final FlybitsViewProviderGetter flybitsViewProviderGetter;
    private final FlybitsNavigator flybitsNavigator;

    @NotNull
    public final LiveData<RepositoryResponse<ViewModelNotificationContent>> getNotificationContents(@Nullable ContentPush findPosition) {
        MutableLiveData liveData = new MutableLiveData();
        this.notificationContentRepository.getNotificationContentRemote((ObjectResultCallback<List<NotificationContent>>)((ObjectResultCallback)new ObjectResultCallback<List<? extends NotificationContent>>(findPosition, liveData){
            final /* synthetic */ ContentPush $findPosition;
            final /* synthetic */ MutableLiveData $liveData;

            public void onSuccess(@NotNull List<NotificationContent> item) {
                Integer n;
                Intrinsics.checkParameterIsNotNull(item, (String)"item");
                if (this.$findPosition != null) {
                    int index;
                    block4: {
                        int n2;
                        List<NotificationContent> $this$indexOfFirst$iv = item;
                        boolean $i$f$indexOfFirst = false;
                        int index$iv = 0;
                        Iterator<NotificationContent> iterator = $this$indexOfFirst$iv.iterator();
                        while (iterator.hasNext()) {
                            NotificationContent item$iv;
                            NotificationContent it = item$iv = iterator.next();
                            boolean bl = false;
                            String string2 = this.$findPosition.getContentId();
                            Content content = it.getBaseTemplate().getContent();
                            Intrinsics.checkExpressionValueIsNotNull((Object)content, (String)"it.baseTemplate.content");
                            if (Intrinsics.areEqual((Object)string2, (Object)content.getId())) {
                                n2 = index$iv;
                                break block4;
                            }
                            ++index$iv;
                        }
                        n2 = index = -1;
                    }
                    n = index == -1 ? null : Integer.valueOf(index);
                } else {
                    n = null;
                }
                Integer position = n;
                this.$liveData.setValue(new RepositoryResponse<T>(new ViewModelNotificationContent(item, position), null, 2, null));
            }

            public void onException(@NotNull FlybitsException exception) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)exception), (String)"exception");
                this.$liveData.setValue(new RepositoryResponse<T>(null, exception, 1, null));
            }
            {
                this.$findPosition = $captured_local_variable$0;
                this.$liveData = $captured_local_variable$1;
            }
        }));
        return (LiveData)liveData;
    }

    @NotNull
    public final LiveData<RepositoryResponse<Boolean>> handlePassedPush(@Nullable Object push) {
        MutableLiveData liveData = new MutableLiveData();
        Object object = push;
        if (object instanceof WeblinkPush) {
            Logger.i((String)"processing web link push");
            this.flybitsNavigator.openUrl(((WeblinkPush)push).getUrl());
            liveData.setValue(new RepositoryResponse(true, null, 2, null));
            return (LiveData)liveData;
        }
        if (object instanceof ContentPush) {
            Logger.i((String)"processing content push");
            this.notificationContentRepository.getBaseTemplate(((ContentPush)push).getContentId(), (ObjectResultCallback<BaseTemplate>)((ObjectResultCallback)new ObjectResultCallback<BaseTemplate>(this, liveData){
                final /* synthetic */ NotificationsViewModel this$0;
                final /* synthetic */ MutableLiveData $liveData;

                public void onSuccess(@NotNull BaseTemplate item) {
                    Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
                    FlybitsViewProviderGetter flybitsViewProviderGetter = NotificationsViewModel.access$getFlybitsViewProviderGetter$p(this.this$0);
                    Object object = item.getContent();
                    if (object == null || (object = object.getType()) == null) {
                        object = "";
                    }
                    FlybitsViewProvider provider = flybitsViewProviderGetter.getFlybitsViewProvider((String)object);
                    if (provider == null) {
                        this.$liveData.setValue(new RepositoryResponse<T>(null, new FlybitsException("No associated FlybitsViewProvider for content"), 1, null));
                    } else {
                        Content content = item.getContent();
                        Logger.d((String)("NotificationsViewModel: content type found = " + (content != null ? content.getType() : null)));
                        provider.onPushOpened(item, NotificationsViewModel.access$getFlybitsNavigator$p(this.this$0));
                        this.$liveData.setValue(new RepositoryResponse<T>(true, null, 2, null));
                    }
                }

                public void onException(@NotNull FlybitsException exception) {
                    Intrinsics.checkParameterIsNotNull((Object)((Object)exception), (String)"exception");
                    this.$liveData.setValue(new RepositoryResponse<T>(null, exception, 1, null));
                }
                {
                    this.this$0 = $outer;
                    this.$liveData = $captured_local_variable$1;
                }
            }));
            return (LiveData)liveData;
        }
        liveData.setValue(new RepositoryResponse(null, new FlybitsException("Expected push, got something else"), 1, null));
        return (LiveData)liveData;
    }

    public NotificationsViewModel(@NotNull NotificationContentRepository notificationContentRepository, @NotNull FlybitsViewProviderGetter flybitsViewProviderGetter, @NotNull FlybitsNavigator flybitsNavigator) {
        Intrinsics.checkParameterIsNotNull((Object)notificationContentRepository, (String)"notificationContentRepository");
        Intrinsics.checkParameterIsNotNull((Object)flybitsViewProviderGetter, (String)"flybitsViewProviderGetter");
        Intrinsics.checkParameterIsNotNull((Object)flybitsNavigator, (String)"flybitsNavigator");
        this.notificationContentRepository = notificationContentRepository;
        this.flybitsViewProviderGetter = flybitsViewProviderGetter;
        this.flybitsNavigator = flybitsNavigator;
    }

    public static final /* synthetic */ FlybitsViewProviderGetter access$getFlybitsViewProviderGetter$p(NotificationsViewModel $this) {
        return $this.flybitsViewProviderGetter;
    }

    public static final /* synthetic */ FlybitsNavigator access$getFlybitsNavigator$p(NotificationsViewModel $this) {
        return $this.flybitsNavigator;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\u0010\b\u0002\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0011\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000bJ,\u0010\u000f\u001a\u00020\u00002\u0010\b\u0002\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0010J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0019\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0015\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/flybits/concierge/viewmodels/NotificationsViewModel$ViewModelNotificationContent;", "", "data", "", "Lcom/flybits/concierge/models/NotificationContent;", "positionOfPush", "", "(Ljava/util/List;Ljava/lang/Integer;)V", "getData", "()Ljava/util/List;", "getPositionOfPush", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "component1", "component2", "copy", "(Ljava/util/List;Ljava/lang/Integer;)Lcom/flybits/concierge/viewmodels/NotificationsViewModel$ViewModelNotificationContent;", "equals", "", "other", "hashCode", "toString", "", "concierge_release"})
    public static final class ViewModelNotificationContent {
        @Nullable
        private final List<NotificationContent> data;
        @Nullable
        private final Integer positionOfPush;

        @Nullable
        public final List<NotificationContent> getData() {
            return this.data;
        }

        @Nullable
        public final Integer getPositionOfPush() {
            return this.positionOfPush;
        }

        public ViewModelNotificationContent(@Nullable List<NotificationContent> data, @Nullable Integer positionOfPush) {
            this.data = data;
            this.positionOfPush = positionOfPush;
        }

        public /* synthetic */ ViewModelNotificationContent(List list, Integer n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                list = null;
            }
            if ((n2 & 2) != 0) {
                n = null;
            }
            this(list, n);
        }

        public ViewModelNotificationContent() {
            this(null, null, 3, null);
        }

        @Nullable
        public final List<NotificationContent> component1() {
            return this.data;
        }

        @Nullable
        public final Integer component2() {
            return this.positionOfPush;
        }

        @NotNull
        public final ViewModelNotificationContent copy(@Nullable List<NotificationContent> data, @Nullable Integer positionOfPush) {
            return new ViewModelNotificationContent(data, positionOfPush);
        }

        public static /* synthetic */ ViewModelNotificationContent copy$default(ViewModelNotificationContent viewModelNotificationContent, List list, Integer n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                list = viewModelNotificationContent.data;
            }
            if ((n2 & 2) != 0) {
                n = viewModelNotificationContent.positionOfPush;
            }
            return viewModelNotificationContent.copy(list, n);
        }

        @NotNull
        public String toString() {
            return "ViewModelNotificationContent(data=" + this.data + ", positionOfPush=" + this.positionOfPush + ")";
        }

        public int hashCode() {
            List<NotificationContent> list = this.data;
            Integer n = this.positionOfPush;
            return (list != null ? ((Object)list).hashCode() : 0) * 31 + (n != null ? ((Object)n).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ViewModelNotificationContent)) break block3;
                    ViewModelNotificationContent viewModelNotificationContent = (ViewModelNotificationContent)object;
                    if (!Intrinsics.areEqual(this.data, viewModelNotificationContent.data) || !Intrinsics.areEqual((Object)this.positionOfPush, (Object)viewModelNotificationContent.positionOfPush)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

