package com.flybits.concierge.utils

import android.graphics.drawable.Drawable
import android.view.View
import android.widget.ImageView
import com.bumptech.glide.request.target.CustomTarget
import com.bumptech.glide.request.transition.Transition
import com.flybits.commons.library.logging.Logger
import com.flybits.concierge.R

/**
 * Loads the image in to imageview with Glide API.
 * @param imageView ImageView object for loading the image in to.
 * @param tagName Tag identifier name.
 * @return target image for Glide.
 */
fun getGlideImageTarget(imageView: ImageView, tagName: String = "DefaultTagName") =
    object : CustomTarget<Drawable>() {
        override fun onLoadFailed(errorDrawable: Drawable?) {
            Logger.appendTag(tagName)
                .e(imageView.context.getString(R.string.flybits_streamline_image_error))
            imageView.visibility = View.GONE
        }

        override fun onResourceReady(
            resource: Drawable,
            transition: Transition<in Drawable>?
        ) {
            imageView.visibility = View.VISIBLE
            imageView.setImageDrawable(resource)
        }

        override fun onLoadCleared(placeholder: Drawable?) {
            // No Operation Implemented.
        }
    }
