package com.flybits.concierge.models

import android.os.Parcel
import android.os.Parcelable
import android.os.Parcelable.Creator
import com.flybits.android.kernel.models.LocalizedValue

/**
 * The {@link CardLink} class is used to define all the necessary parameters associated to
 * link data included in SimpleCard or ActionCard data.
 */
class CardLink : Parcelable {

    var actionType: String? = null
    var actionValue: LocalizedValue? = null
    var text: LocalizedValue? = null


    constructor() : super()

    constructor(`in`: Parcel)  {
        actionType = `in`.readString()
        actionValue = `in`.readParcelable(LocalizedValue::class.java.classLoader)
        text = `in`.readParcelable(LocalizedValue::class.java.classLoader)
    }

    override fun writeToParcel(dest: Parcel?, flags: Int) {
        dest?.let {
            dest.writeString(actionType)
            dest.writeParcelable(actionValue, flags)
            dest.writeParcelable(text, flags)
        }
    }

    override fun describeContents(): Int = 0

    companion object {
        @JvmField
        val CREATOR: Creator<CardLink> =
            object : Creator<CardLink> {
                override fun createFromParcel(`in`: Parcel): CardLink? {
                    return CardLink(`in`)
                }

                override fun newArray(size: Int): Array<CardLink?> {
                    return arrayOfNulls(size)
                }
            }
    }
}