package com.flybits.concierge.guidedoptin.presentation.view

import android.arch.lifecycle.ViewModelProviders
import android.os.Bundle
import android.support.v4.app.Fragment
import android.support.v7.widget.LinearLayoutManager
import android.text.method.ScrollingMovementMethod
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.TextView
import com.flybits.concierge.R
import com.flybits.concierge.guidedoptin.presentation.adapter.NotificationOptInAdapter
import com.flybits.concierge.guidedoptin.presentation.viewmodel.GuidedOptInViewModel
import com.flybits.concierge.utils.areNotificationEnabled
import kotlinx.android.synthetic.main.flybits_fragment_guided_notification.*

/**
 * This NotificationOptInFragment is responsible for Notification Guided Opt In UI.
 */
internal class NotificationsOptInFragment : Fragment() {

    private val viewModel: GuidedOptInViewModel by lazy {
        ViewModelProviders.of(activity!!).get(GuidedOptInViewModel::class.java)
    }

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        return inflater.inflate(R.layout.flybits_fragment_guided_notification, container, false)
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)

        val supportActionBarTitle: TextView? =
            activity?.findViewById(R.id.flybits_guided_toolbar_title)
        supportActionBarTitle?.text = getString(R.string.flybits_guided_notification_appbar_title)

        viewModel.getNotificationOptIn()?.let {
            flybits_guided_notification_title.text = getString(it.title)
            flybits_guided_notification_next.text = getString(it.nextTitle)
            flybits_guided_notification_disclaimer.movementMethod = ScrollingMovementMethod()
            flybits_guided_notification_disclaimer.text = getString(it.disclaimerText)

            if (it.info.isNotEmpty()) {
                flybits_guided_notification_rv.apply {
                    layoutManager = LinearLayoutManager(context)
                    adapter = NotificationOptInAdapter(it.info)
                    addItemDecoration(
                        MarginItemDecoration(
                            resources.getDimension(R.dimen.flybits_content_margin_xxlarge)
                                .toInt(), it.info.size
                        )
                    )
                }
            }
        }

        flybits_guided_notification_next.setOnClickListener {
            viewModel.onNotificationsContinueClicked()
        }
    }

    companion object {
        fun newInstance() = NotificationsOptInFragment()
    }
}