package com.flybits.concierge.guidedoptin.presentation.adapter

import android.support.v7.widget.RecyclerView
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.TextView
import com.bumptech.glide.Glide
import com.flybits.concierge.R
import com.flybits.concierge.guidedoptin.presentation.model.NotificationsOptInItem

/**
 * Adapter responsible for populating notification opt-in Ui recyclerview
 */
internal class NotificationOptInAdapter(var notificationOptInItems: List<NotificationsOptInItem>) :
    RecyclerView.Adapter<NotificationOptInAdapter.NotificationOptInViewHolder>() {

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): NotificationOptInViewHolder {
        return NotificationOptInViewHolder(
            LayoutInflater.from(parent.context)
                .inflate(R.layout.flybits_guided_notification_item, parent, false)
        )
    }

    override fun getItemCount(): Int {
        return notificationOptInItems.size
    }

    class NotificationOptInViewHolder(view: View) : RecyclerView.ViewHolder(view) {
        var image: ImageView = view.findViewById(R.id.flybits_guided_notification_item_image)
        var body: TextView = view.findViewById(R.id.flybits_guided_notification_item_text)
    }

    override fun onBindViewHolder(holder: NotificationOptInViewHolder, position: Int) {
        if (notificationOptInItems[position].image != 0) {
            Glide.with(holder.image.context).load(notificationOptInItems[position].image)
                .into(holder.image)
        } else {
            holder.image.visibility = View.GONE
        }
        holder.body.setText(notificationOptInItems[position].body)
    }
}