package com.flybits.concierge.guidedoptin.domain.usecase

import com.flybits.concierge.guidedoptin.domain.UseCase
import com.flybits.concierge.guidedoptin.domain.entity.GuidedOptInEntity
import com.flybits.concierge.guidedoptin.domain.repository.GuidedOptInRepository
import java.io.InputStream

/**
 * The [UseCase] that encapsulates task to get [GuidedOptInEntity].
 */
internal class GetGuidedOptInUseCase(private val repository: GuidedOptInRepository, private val stream: InputStream, private val debug: Boolean): UseCase<GuidedOptInEntity?, Void> {
    override suspend fun execute(vararg args: Void): GuidedOptInEntity? = repository.getGuidedOptInEntity(stream, debug)
}