package com.flybits.concierge.activities

import android.content.Intent
import android.os.Bundle
import android.support.v4.app.Fragment
import com.flybits.commons.library.exceptions.FlybitsException
import com.flybits.commons.library.logging.Logger
import com.flybits.concierge.FlybitsConcierge
import com.flybits.concierge.R
import com.flybits.concierge.fragments.DocumentFragment
import kotlinx.android.synthetic.main.flybits_con_activity_document.*

/**
 * This activity is responsible for displaying either the Terms of Service or Privacy Policy.
 */
class DocumentActivity: SingleFragmentActivity() {

    companion object {
        const val EXTRA_DOCUMENT_TYPE = "flybits_con_extra_document_type"
        const val DOCUMENT_TYPE_PRIVACY_POLICY = "flybits_con_document_type_privacy_policy"
        const val DOCUMENT_TYPE_TOS= "flybits_con_document_type_terms_of_service"
        const val DOCUMENT_TYPE_URL= "flybits_con_document_type_url"
        const val EXTRA_DOCUMENT_CLIENT_URL= "flybits_con_document_client_url"
    }

    override fun onCreateSingleContentActivity(intent: Intent): Fragment {
        val type: String = intent.extras?.getString(EXTRA_DOCUMENT_TYPE, DOCUMENT_TYPE_PRIVACY_POLICY) ?: ""
        return when (type){
            DOCUMENT_TYPE_PRIVACY_POLICY -> {
                val url = FlybitsConcierge.with(this).configuration.privacyPolicyUrl
                val text = FlybitsConcierge.with(this).configuration.privacyPolicyText
                DocumentFragment.newInstance(url,text)
            }
            DOCUMENT_TYPE_TOS -> {
                val url = FlybitsConcierge.with(this).configuration.tncUrl
                val text = FlybitsConcierge.with(this).configuration.tncText
                DocumentFragment.newInstance(url,text)
            }
            DOCUMENT_TYPE_URL -> {
                val url: String = intent.extras?.getString(EXTRA_DOCUMENT_CLIENT_URL) ?: ""
                val text = null
                DocumentFragment.newInstance(url,text)
            }
            else -> {
                val e = FlybitsException("Invalid document type found")
                Logger.exception("DocumentActivity.onCreateSingleContentActivity", e)
                throw e
            }
        }
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        setContentView(R.layout.flybits_con_activity_document)

        // add custom back button
        setSupportActionBar(document_toolbar)
        supportActionBar?.setDisplayHomeAsUpEnabled(true);
        supportActionBar?.setDisplayShowHomeEnabled(true);
        supportActionBar?.title = ""

        val type: String = intent.extras?.getString(EXTRA_DOCUMENT_TYPE, DOCUMENT_TYPE_PRIVACY_POLICY) ?: ""
        when (type){
            DOCUMENT_TYPE_PRIVACY_POLICY -> {
                document_activity_toolbar_title.text = resources.getString(R.string.flybits_con_settings_privacy_policy)
            }
            DOCUMENT_TYPE_TOS -> {
                document_activity_toolbar_title.text = resources.getString(R.string.flybits_con_settings_terms_of_service)
            }
            else -> {
                document_activity_toolbar_title.text = ""
            }
        }
    }
}