package com.flybits.concierge;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.Nullable;

public class InternalPreferences {

    protected final static String IS_2PHASE_OPTED_IN = "ctn_flybits_2_phase_opted_in";
    private final static String PREFS_NAME = "ConciergePrefs";
    private final static String TNC_ACCEPTED = "tnc_accepted";
    private final static String FB_PUSH_TOKEN = "fire_base_push_token";
    private final static String ONBOARDING_DONE = "onboarded";
    private final static String AUTO_AUTH_ON_CONNECT = "auto_authenticate";
    private final static String SELF_USER_OPTED_OUT = "self_optOut";
    private final static String IS_OPTOUT_CONFIRMATION = "opt_out_confirmation";
    private final static String IS_OPTOUTCONFIRMATION_ADDED = "optOutConfirmation_added";
    private final static String IS_LAUNCHED_GUIDEDOPTIN = "from_guided_opt_in";
    private final static String IS_TWOPHASE_CONCIERGE = "is_twophase_concierge";

    private static SharedPreferences getInstance(Context context) {
        return context.getSharedPreferences(PREFS_NAME, Context.MODE_PRIVATE);
    }

    public static void saveTNCAccepted(Context currentContext, boolean value) {
        currentContext.getSharedPreferences(PREFS_NAME, Context.MODE_PRIVATE).edit().putBoolean(TNC_ACCEPTED, value).apply();
    }

    private static SharedPreferences.Editor getSaveInstance(Context context) {
        return getInstance(context).edit();
    }

    public static boolean isTNCAccepted(Context context) {
        return getInstance(context).getBoolean(TNC_ACCEPTED, false);
    }

    public static void setAutoRetryAuthOnConnected(Context currentContext, boolean value) {
        getSaveInstance(currentContext).putBoolean(AUTO_AUTH_ON_CONNECT, value).apply();
    }

    public static boolean isAutoRetryAuthOnConnectedEnabled(Context currentContext) {
        //This option is true by default
        return getInstance(currentContext).getBoolean(AUTO_AUTH_ON_CONNECT, true);
    }

    public static boolean isOnBoardingDone(Context context) {
        return getInstance(context).getBoolean(ONBOARDING_DONE, false);
    }

    public static void saveOnBoardingDone(Context currentContext, boolean value) {
        getSaveInstance(currentContext)
                .putBoolean(ONBOARDING_DONE, value)
                .apply();
    }

    public static void savePushToken(Context currentContext, String value) {
        getSaveInstance(currentContext)
                .putString(FB_PUSH_TOKEN, value)
                .apply();
    }

    public static String pushToken(Context currentContext) {
        return getInstance(currentContext).getString(FB_PUSH_TOKEN, null);
    }

    public static boolean is2PhaseOptIn(Context currentContext) {
        return getInstance(currentContext).getBoolean(IS_2PHASE_OPTED_IN, false);
    }

    public static void setIs2phaseOptedIn(Context currentContext, boolean value) {
        getSaveInstance(currentContext)
                .putBoolean(IS_2PHASE_OPTED_IN, value)
                .apply();
    }

    public static void setSelfUserOptedOut(Context currentContext, boolean value) {
        getSaveInstance(currentContext)
                .putBoolean(SELF_USER_OPTED_OUT, value)
                .apply();
    }

    static boolean isSelfOptedOut(Context currentContext) {
        return getInstance(currentContext).getBoolean(SELF_USER_OPTED_OUT, false);
    }

    // sharedPreference for whether or not stop at OptOutConfirmationFragment
    public static boolean isOptOutConfirmation(Context currentContext) {
        return getInstance(currentContext).getBoolean(IS_OPTOUT_CONFIRMATION, false);
    }

    public static void setOptOutConfirmation(Context currentContext, boolean value) {
        getSaveInstance(currentContext)
                .putBoolean(IS_OPTOUT_CONFIRMATION, value)
                .apply();
    }

    // sharedPreference for whether or not OptOutConfirmation is on backStack
    public static boolean isOptOutConfirmationAdded(Context currentContext) {
        return getInstance(currentContext).getBoolean(IS_OPTOUTCONFIRMATION_ADDED, false);
    }

    public static void setOptOutConfirmationAdded(Context currentContext, boolean value) {
        getSaveInstance(currentContext)
                .putBoolean(IS_OPTOUTCONFIRMATION_ADDED, value)
                .apply();
    }


    // sharedPreference for whether or not it lands on TransitionLoaderFragment from GuidedOptInActivity
    public static boolean isLaunchedFromGuidedOptInActivity(@Nullable final Context currentContext) {
        return getInstance(currentContext).getBoolean(IS_LAUNCHED_GUIDEDOPTIN, false);
    }

    public static void setLaunchedFromGuidedOptInActivity(@Nullable final Context currentContext, boolean value) {
        getSaveInstance(currentContext)
                .putBoolean(IS_LAUNCHED_GUIDEDOPTIN, value)
                .apply();
    }


    // sharedPreference to check ConciergeFragment is hosted by Client Developer for two phase.
    public static boolean isTwoPhaseConciergeFragment(@Nullable final Context currentContext) {
        return getInstance(currentContext).getBoolean(IS_TWOPHASE_CONCIERGE, false);
    }

    public static void setTwoPhaseConciergeFragment(@Nullable final Context currentContext, boolean value) {
        getSaveInstance(currentContext)
                .putBoolean(IS_TWOPHASE_CONCIERGE, value)
                .apply();
    }
}
