/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.concierge.services;

import android.content.Context;
import androidx.work.ListenableWorker;
import androidx.work.Worker;
import androidx.work.WorkerParameters;
import com.flybits.android.kernel.db.KernelDatabase;
import com.flybits.android.kernel.db.dao.ContentDao;
import com.flybits.android.kernel.models.Content;
import com.flybits.android.kernel.utilities.ContentParameters;
import com.flybits.commons.library.api.results.callbacks.ObjectResultCallback;
import com.flybits.commons.library.api.results.callbacks.PagedResultCallback;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.logging.Logger;
import com.flybits.commons.library.models.internal.Pagination;
import com.flybits.concierge.R;
import com.flybits.concierge.models.Category;
import com.flybits.concierge.models.CategorySettings;
import com.flybits.concierge.repository.ProjectSettingsGetter;
import com.flybits.concierge.repository.category.CategoryDao;
import com.flybits.concierge.repository.category.CategoryDatabase;
import com.flybits.concierge.repository.category.CategorySettingsRepository;
import com.flybits.concierge.repository.content.ContentGetter;
import com.flybits.concierge.repository.content.ContentRepository;
import com.flybits.internal.db.CachingEntryDAO;
import com.flybits.internal.db.CommonsDatabase;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\u001c\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/flybits/concierge/services/PreloadingWorker;", "Landroidx/work/Worker;", "context", "Landroid/content/Context;", "workerParams", "Landroidx/work/WorkerParameters;", "(Landroid/content/Context;Landroidx/work/WorkerParameters;)V", "doWork", "Landroidx/work/ListenableWorker$Result;", "loadContentPage", "", "label", "", "contentRepository", "Lcom/flybits/concierge/repository/content/ContentRepository;", "Companion", "concierge_release"})
public final class PreloadingWorker
extends Worker {
    public static final int MAX_CATEGORY_PRELOAD = 5;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public ListenableWorker.Result doWork() {
        Logger.d((String)(PreloadingWorker.class.getSimpleName() + ": Preloading worker running"));
        Context context = this.getApplicationContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"applicationContext");
        Object object = CategoryDatabase.Companion.getInstance$default(CategoryDatabase.Companion, context, false, 2, null);
        if (object == null || (object = object.categoryDao()) == null) {
            ListenableWorker.Result result = ListenableWorker.Result.failure();
            Intrinsics.checkExpressionValueIsNotNull((Object)result, (String)"Result.failure()");
            return result;
        }
        Object categoryDao = object;
        Context context2 = this.getApplicationContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"applicationContext");
        ProjectSettingsGetter projectSettingsGetter = new ProjectSettingsGetter(context2);
        CategorySettingsRepository categorySettingsRepository = new CategorySettingsRepository((CategoryDao)categoryDao, projectSettingsGetter);
        Context context3 = this.getApplicationContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context3, (String)"applicationContext");
        ContentGetter contentGetter = new ContentGetter(context3);
        ContentDao contentDao = KernelDatabase.getDatabase((Context)this.getApplicationContext()).contentDao();
        CachingEntryDAO cachingEntryDao = CommonsDatabase.getDatabase((Context)this.getApplicationContext()).cachingEntryDAO();
        ContentDao contentDao2 = contentDao;
        Intrinsics.checkExpressionValueIsNotNull((Object)contentDao2, (String)"contentDao");
        CachingEntryDAO cachingEntryDAO = cachingEntryDao;
        Intrinsics.checkExpressionValueIsNotNull((Object)cachingEntryDAO, (String)"cachingEntryDao");
        ContentRepository contentRepository = new ContentRepository(contentGetter, contentDao2, cachingEntryDAO);
        CategorySettingsRepository.getCategorySettingsRemote$default(categorySettingsRepository, (ObjectResultCallback)new ObjectResultCallback<CategorySettings>(this, contentRepository){
            final /* synthetic */ PreloadingWorker this$0;
            final /* synthetic */ ContentRepository $contentRepository;

            public void onSuccess(@NotNull CategorySettings item) {
                Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
                Logger.d((String)(PreloadingWorker.class.getSimpleName() + ": Successfully preloaded categories: " + item.getCategories()));
                PreloadingWorker.loadContentPage$default(this.this$0, null, this.$contentRepository, 1, null);
                CategorySettings categorySettings = item;
                boolean bl = false;
                boolean bl2 = false;
                CategorySettings categorySettingsNotNull = categorySettings;
                boolean bl3 = false;
                int sublistSize = 5 > categorySettingsNotNull.getCategories().size() ? categorySettingsNotNull.getCategories().size() : 5;
                Iterable $this$forEach$iv = categorySettingsNotNull.getCategories().subList(0, sublistSize);
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Category it = (Category)element$iv;
                    boolean bl4 = false;
                    PreloadingWorker.access$loadContentPage(this.this$0, it.getName(), this.$contentRepository);
                }
            }

            public void onException(@NotNull FlybitsException exception) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)exception), (String)"exception");
                Logger.d((String)(PreloadingWorker.class.getSimpleName() + ": Error preloading categories"));
            }
            {
                this.this$0 = $outer;
                this.$contentRepository = $captured_local_variable$1;
            }
        }, null, 2, null);
        ListenableWorker.Result result = ListenableWorker.Result.success();
        Intrinsics.checkExpressionValueIsNotNull((Object)result, (String)"Result.success()");
        return result;
    }

    private final void loadContentPage(String label, ContentRepository contentRepository) {
        ContentParameters.Builder paramsBuilder = ((ContentParameters.Builder)new ContentParameters.Builder().setPaging((long)20, 0L)).setCaching(this.getApplicationContext().getString(R.string.flybits_con_cache_key), 20);
        if (label != null) {
            paramsBuilder.setLabels(label);
        }
        ContentParameters contentParameters = paramsBuilder.setRichTextContent(true).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)contentParameters, (String)"paramsBuilder.setRichTextContent(true).build()");
        contentRepository.getContent(contentParameters, (PagedResultCallback<Content>)((PagedResultCallback)new PagedResultCallback<Content>(label){
            final /* synthetic */ String $label;

            public void onSuccess(@NotNull ArrayList<Content> items, @NotNull Pagination pagination) {
                Intrinsics.checkParameterIsNotNull(items, (String)"items");
                Intrinsics.checkParameterIsNotNull((Object)pagination, (String)"pagination");
                Logger.d((String)(PreloadingWorker.class.getSimpleName() + ": Successfully preloaded content for label: " + this.$label));
            }

            public void onLoadedAllItems() {
            }

            public void onException(@NotNull FlybitsException exception) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)exception), (String)"exception");
                Logger.d((String)(PreloadingWorker.class.getSimpleName() + ": Error preloading content for label: " + this.$label));
            }
            {
                this.$label = $captured_local_variable$0;
            }
        }));
    }

    static /* synthetic */ void loadContentPage$default(PreloadingWorker preloadingWorker, String string2, ContentRepository contentRepository, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = null;
        }
        preloadingWorker.loadContentPage(string2, contentRepository);
    }

    public PreloadingWorker(@NotNull Context context, @NotNull WorkerParameters workerParams) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)workerParams, (String)"workerParams");
        super(context, workerParams);
    }

    public static final /* synthetic */ void access$loadContentPage(PreloadingWorker $this, String label, ContentRepository contentRepository) {
        $this.loadContentPage(label, contentRepository);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/flybits/concierge/services/PreloadingWorker$Companion;", "", "()V", "MAX_CATEGORY_PRELOAD", "", "concierge_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

